/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.LibraryClassReader;
import proguard.classfile.io.ProgramClassReader;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;

public class ClassReader
implements DataEntryReader {
    private final boolean isLibrary;
    private final boolean skipNonPublicLibraryClasses;
    private final boolean skipNonPublicLibraryClassMembers;
    private final WarningPrinter warningPrinter;
    private final ClassVisitor classVisitor;

    public ClassReader(boolean bl, boolean bl2, boolean bl3, WarningPrinter warningPrinter, ClassVisitor classVisitor) {
        this.isLibrary = bl;
        this.skipNonPublicLibraryClasses = bl2;
        this.skipNonPublicLibraryClassMembers = bl3;
        this.warningPrinter = warningPrinter;
        this.classVisitor = classVisitor;
    }

    public void read(DataEntry dataEntry) throws IOException {
        try {
            Clazz clazz;
            InputStream inputStream = dataEntry.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (this.isLibrary) {
                clazz = new LibraryClass();
                clazz.accept(new LibraryClassReader(dataInputStream, this.skipNonPublicLibraryClasses, this.skipNonPublicLibraryClassMembers));
            } else {
                clazz = new ProgramClass();
                clazz.accept(new ProgramClassReader(dataInputStream));
            }
            String string = clazz.getName();
            if (string != null) {
                if (!dataEntry.getName().replace(File.pathSeparatorChar, '/').equals(string + ".class") && this.warningPrinter != null) {
                    this.warningPrinter.print(string, "Warning: class [" + dataEntry.getName() + "] unexpectedly contains class [" + ClassUtil.externalClassName(string) + "]");
                }
                clazz.accept(this.classVisitor);
            }
            dataEntry.closeInputStream();
        }
        catch (Exception exception) {
            throw new IOException("Can't process class [" + dataEntry.getName() + "] (" + exception.getMessage() + ")");
        }
    }
}

