/******************************************************************************\
**	directwrite.c
**
**	First release:			Thursday, April 4, 2002
**	Latest release:			Thursday, April 19, 2002
*****************************************************************************
**	
**	Licensed by:	Persistor Instruments Inc. for the Peristor CF2
**	info@persistor.com - http://www.persistor.com
**	
*****************************************************************************
**	
**	Developed by:	John H. Godley Persistor Instruments
**	jhgodley@persistor.com - http://www.persistor.com
**	Copyright (C) 1996-2002  Persistor Instruments.	All rights reserved.
**
**	Modification by Thomas P. Sullivan
**	tpsully@persistor.com
**	04/04/02
**	
*****************************************************************************
**	
** Copyright and License Information
** 
** Persistor Instruments Inc. (hereafter, PII) grants you (hereafter,
** Licensee) a non-exclusive, non-transferable license to use the software
** source code contained in this single source file with hardware products
** sold by PII. Licensee may distribute binary derivative works using this
** software and running on PII hardware products to third parties without
** fee or other restrictions.
** 
** PII MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
** SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
** OR NON-INFRINGEMENT. PII SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
** LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THE SOFTWARE OR
** ITS DERIVATIVES.
** 
** By using or copying this Software, Licensee agrees to abide by the
** copyright law and all other applicable laws of the U.S. including, but
** not limited to, export control laws, and the terms of this license. PII
** shall have the right to terminate this license immediately by written
** notice upon Licensee's breach of, or non-compliance with, any of its
** terms. Licensee may be held legally responsible for any copyright
** infringement or damages resulting from Licensee's failure to abide by
** the terms of this license. 
**
\******************************************************************************/

#define	PD_CMD_BUILD_LINKS	// MUST APPEAR BEFORE #include <cfxpico.h>	

//#define DEBUG
#ifdef DEBUG
  #define	DBG(X)	X	// template:	DBG( cprintf("\n"); )
  #pragma message	("!!! "__FILE__ ": Don't ship with DEBUG compile flag set!")
#else
  #define	DBG(X)		// nothing
#endif

#include	<cfxbios.h>		// Persistor BIOS and I/O Definitions
#include	<cfxpico.h>		// Persistor PicoDOS Definitions

#include	<assert.h>
#include	<ctype.h>
#include	<errno.h>
#include	<float.h>
#include	<limits.h>
#include	<locale.h>
#include	<math.h>
#include	<setjmp.h>
#include	<signal.h>
#include	<stdarg.h>
#include	<stddef.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

#include	<dirent.h>		// PicoDOS POSIX-like Directory Access Defines
#include	<dosdrive.h>	// PicoDOS DOS Drive and Directory Definitions
#include	<fcntl.h>		// PicoDOS POSIX-like File Access Definitions
#include	<stat.h>		// PicoDOS POSIX-like File Status Definitions
#include	<termios.h>		// PicoDOS POSIX-like Terminal I/O Definitions
#include	<unistd.h>		// PicoDOS POSIX-like UNIX Function Definitions


//	Dummy template function prototype for all CMD table functions. Copy and 
//	paste the following line, then rename TemplateCmd to your functions name.
char	*TemplateCmd(CmdInfoPtr cip);	// ?????????

char	*StartAD(CmdInfoPtr cip);
int		FastAD(ulong startsect, ulong endsect);

char	*SectorTimeCmd(CmdInfoPtr cip);

char	*GetFirstLastSectors(CmdInfoPtr cip);
char	*DumpDataSectors(CmdInfoPtr cip);
char	*PrepForFakeFile(CmdInfoPtr cip);

char	*ArgsCmd(CmdInfoPtr cip);
char	*SwitchesCmd(CmdInfoPtr cip);
char	*PicoCmd(CmdInfoPtr cip);

CmdTable		MyPicoCmdTable[] = 
	{
//	PROMPT			HANDLER				2COLS DEF  CR  ABV	HEADER TEXT
	""				, PDCCmdStdInteractive,	1,	0,	1,	0,	
	"\n~~~~~~~~~~~~~~~~~~~~~  MyPico custom commands   ~~~~~~~~~~~~~~~~~~~~~"
//	 COMMAND		COMMAND				  MIN PRV  CR NUM	SHORT HELP TEXT
//	  NAME			FUNCTION			  REQ LEV REP BASE	EMPTY STRING "" TO 
//	(CONSTANT)		POINTER				  ARG REQ  OK 0=NO	OMIT FROM HELP LIST

//	vvvvvvvv KEEP THESE COMMANDS NEAR THE TOP TO MINIMIZE SEARCH TIME vvvvvvvv
	,"LOAD"			, PDCLoadMxCmd,			0,	0,	0,	16,	""
	,"PBM"			, PDCResetToPBMCmd,		0,	0,	0,	0,	""	
	,"MON"			, PDCResetToPBMCmd,		0,	0,	0,	0,	""
//	THESE TWO KEEP MOTOCROSS IN CHECK DURING LOADS 98/06/05--jhg
	,"."			, PDCNothingCmd,		0,	0,	0,	0,	""
	,"\003"			, PDCNothingCmd,		0,	0,	0,	0,	""
//------------------------------------------------------------------------------------
//	YOUR COMMANDS SHOULD FOLLOW:
//		Command entries can actually go anywhere in the table, but placing them
//		at the top has them show first in the help command.
//------------------------------------------------------------------------------------

	,"FL"			, GetFirstLastSectors,	0,	10,	0,	0,	"First/last sectors"
	,"DD"			, DumpDataSectors,		0,	10,	0,	10,	"Dump data sectors"
	,"PREP"			, PrepForFakeFile,		1,	10,	0,	10,	"filename"
	,"ST"			, SectorTimeCmd,		0,	10,	0,	10,	"sector wr time [count]"

	,"STARTAD"		, StartAD,				0,	10,	0,	0,	"Collect Data"


//------------------------------------------------------------------------------------
//	STANARD PICODOS COMMANDS FOLLOW: (comment them out to remove or override)
//------------------------------------------------------------------------------------

	,"APP"			, PDCGoCmd,				0,	0,	0,	16,	"run flash app [args...]"
	,"ATTRIB"		, PDCAttribCmd,			0,	10,	0,	0,	"[+ - RASH] [d:][p][name]"
	,"BACKROM"		, PDCBackROMCmd,		0,	10,	0,	16,	"[d:][path] [/SAVI]"
	,"BAUD"			, PDCBaudCmd,			0,	0,	0,	10,	"[newrate] [/Q/P/E/O/N/2]"
	,"BOOT"			, PDCBootCmd,			0,	0,	0,	0,	"[PICO][PBM][APP]"
	,"CAPTURE"		, PDCCaptureCmd,		0,	10,	0,	16,	"[d:][p]fn [/Dx/B/N/E]"
	,"CCC"			, PDCCardChangeCmd,		0,	0,	0,	10,	"Card Change [delay secs]"
	,"CHDIR"		, PDCCHDirCmd,			0,	10,	0,	0,	"[drive:][path]"
	,"CHKDSK"		, PDCChkdskCmd,			0,	7,	0,	16,	"[d:][p][fn] [/F][/I]"
	,"COPY"			, PDCCopyCmd,			0,	10,	0,	0,	"source dest [/V]"
	,"DUMP"			, PDCDumpCmd,			0,	10,	0,	16,	"file[start[,end]]"
	,"DATE"			, PDCDateCmd,			0,	0,	1,	0,	"[mdy[hms[a|p]]] /IEUMCP]"
	,"DEL"			, PDCDelCmd,			0,	10,	0,	0,	"[drv:][pth][name] [/P]"
	,"DIR"			, PDCDirCmd,			0,	10,	0,	16,	"[d:][p][fn] [/PWBLV4A:a]"
	,"ERASE"		, PDCDelCmd,			0,	10,	0,	0,	"[drv:][pth][name] [/P]"
	,"FDISK"		, PDCFdiskCmd,			0,	7,	0,	16,	"[/Pnn/M/Sdev/@/F/Rnn/Q]"
//	,"FORMAT"		, PDCFormatCmd,			0,	7,	0,	0,	"[drv:][/V[:label]][/Q/E]"	//Commented out so command not available
	,"GO"			, PDCGoCmd,				0,	0,	0,	16,	"args... | addr /A | /Fn"
	,"LO"			, PDCLoadSRecCmd,		0,	0,	0,	16,	"[ofs][;Bx[+]] [;G]"
	,"MOUNT"		, PDCMountCmd,			0,	0,	0,	16,	"[V:][DEV[-n][/D/P/N/V/Q]"
	,"MKDIR"		, PDCMKDirCmd,			0,	10,	0,	0,	"[drive:][path]"
	,"MD"			, PDCMemDispCmd,		0,	0,	1,	16,	"display [range]"
	,"MM"			, PDCMemModCmd,			0,	0,	1,	16,	"modify [address]"
	,"ML"			, PDCMemListCmd,		0,	0,	1,	16,	"disassemble [range]"
	,"MON"			, PDCResetToPBMCmd,		0,	0,	0,	0,	"Reset to PBM"
	,"PATH"			, PDCPathCmd,			0,	0,	0,	0,	"[[d:]path[;...]] [/P]"
	,"PBM"			, PDCResetToPBMCmd,		0,	0,	0,	0,	"Reset to PBM"
	,"PROMPT"		, PDCPromptCmd,			0,	0,	0,	0,	"[text] [/P]"
	,"PR"			, PDCPortReadCmd,		1,	0,	1,	10,	"pin read    <1..50>"
	,"PC"			, PDCPortClrCmd,		1,	0,	0,	10,	"pin clear   <1..50>"
	,"PS"			, PDCPortSetCmd,		1,	0,	0,	10,	"pin set     <1..50>"
	,"PT"			, PDCPortToggleCmd,		1,	0,	1,	10,	"pin toggle  <1..50>"
	,"PM"			, PDCPortMirrorCmd,		1,	0,	1,	10,	"pin mirror  <1..50>"
	,"TIME"			, PDCTimeCmd,			0,	0,	1,	0,	"[hh:mm:ss [a|p]] [/M/C]"
	,"TYPE"			, PDCTypeCmd,			0,	10,	0,	0,	"[drv:][pth][name]"
	,"REN"			, PDCRenCmd,			0,	10,	0,	0,	"[d:][p]oldname newname"
	,"RESET"		, PDCResetCmd,			0,	0,	0,	0,	"(hard reset)"	
	,"RMDIR"		, PDCRMDirCmd,			0,	10,	0,	0,	"[drive:][path]"
	,"SAVE"			, PDCSaveCmd,			0,	10,	0,	16,	"file[start][end]"
	,"SD"			, PDCSectorDumpCmd,		0,	7,	1,	16,	"sect.dump[d:][range][/C]"
	,"SET"			, PDCSetCmd,			0,	0,	0,	0,	"[var=[str]] [/SLFE?]"
	,"XS"			, PDCXSCmd,				0,	10,	0,	0,	"[/X][/C][/Q]file"
	,"XR"			, PDCXRCmd,				0,	10,	0,	0,	"[/X][/C][/Q][file]"
	,"YS"			, PDCYSCmd,				0,	10,	0,	0,	"[/G][/Q]file[,file...]"
	,"YR"			, PDCYRCmd,				0,	10,	0,	0,	"[/G][/Q]"
	,"VER"			, PDCVerCmd,			0,	0,	0,	0,	"Firmware versions"

//------------------------------------------------------------------------------------
// Future placeholders for PicoDOS

	,"BREAK"		, PDCBreakCmd,			0,	0,	0,	0,	""
	,"CLS"			, PDCCLSCmd,			0,	0,	0,	0,	""
	,"DEVICE"		, PDCDeviceCmd,			0,	0,	0,	0,	""
	,"EXIT"			, PDCExitCmd,			0,	0,	0,	0,	""
	,"INSTALL"		, PDCInstallCmd,		0,	0,	0,	0,	""
	,"LABEL"		, PDCLabelCmd,			0,	0,	0,	0,	""
	,"MEM"			, PDCMemCmd,			0,	0,	0,	0,	""
	,"MODE"			, PDCModeCmd,			0,	0,	0,	0,	""
	,"PATH"			, PDCPathCmd,			0,	0,	0,	0,	""
	,"VOL"			, PDCVolCmd,			0,	0,	0,	0,	""

//------------------------------------------------------------------------------------
	,"GSAVE"		, PDCSaveCmd,			0,	10,	0,	16,	""
	,"GS"			, PDCSaveCmd,			0,	10,	0,	16,	""
	,"CD"			, PDCCHDirCmd,			0,	10,	0,	0,	""
	,"CD."			, PDCCHDirCmd,			0,	10,	0,	0,	""
	,"CD.."			, PDCCHDirCmd,			0,	10,	0,	0,	""
	,"MKD"			, PDCMKDirCmd,			0,	10,	0,	0,	""
	,"RD"			, PDCRMDirCmd,			0,	10,	0,	0,	""
	,"HELP"			, PDCHelpCmd,			0,	0,	0,	0,	""
	,"HE"			, PDCHelpCmd,			0,	0,	0,	0,	""
	,"H"			, PDCHelpCmd,			0,	0,	0,	0,	""
	,"?"			, PDCHelpCmd,			0,	0,	0,	0,	""
	,"RES"			, PDCResetCmd,			0,	0,	0,	0,	""	
	,"G"			, PDCGoCmd,				0,	0,	0,	16,	""
	,"GO"			, PDCGoCmd,				0,	0,	0,	16,	""
	,"CRC"			, PDCCRCCmd,			0,	0,	0,	16,	""

	,"CMD10"		, PDCCmdStdCmdTest,		0,	0,	0,	10,	""
	,"CMD16"		, PDCCmdStdCmdTest,		0,	0,	0,	16,	""

	//TERMINATING ENTRY (!!!!This must be present at end of table !!!!)
	,""				, 0,					0,	0,	0,	0,	0
	};


/******************************************************************************\
**	main		Main Entry Point
\******************************************************************************/
void main(void)
	{
//	extern CmdTable		MyPicoCmdTable[]; // only declare if in another file
	CmdInfo				ci, *cip = &ci;
	
	// Identify the program and build
	cprintf("\nProgram: %s: %s %s \n", __FILE__, __DATE__, __TIME__);

//
//	ENTER INTERACTIVE COMMAND PROCESSING MODE
//
	CmdStdSetup(&ci, MyPicoCmdTable, PICOHandlerAddress(CmdStdLPGets));
	cip->privLevel = 100;		// accept all

	execstr("PROMPT BB)$P$G");

	CmdStdPicoRun(cip);


	}	//____ main() ____//


ulong	FirstDataSectorDSDRel = 0;	// first and last data sectors ...
ulong	LastDataSectorDSDRel = 0;	// ... relative to volume boot record
ulong	DataSectorCapacity = 0;


/******************************************************************************\
**	GetFirstLastSectors
\******************************************************************************/
char *GetFirstLastSectors(CmdInfoPtr cip)
	{
	short		err;
	short		logdrv = DSDGetCurrentDrive();
	DOSWorkingBootParamBlock		dwbpb;
	DOSPackedBootParamBlock			dpbpb;

	if ((err = DBRGetBootParamBlock(logdrv, &dpbpb)) != 0)
		return CmdErrf(cip, err, CmdDriveError);
	DBRUnpackParamBlock(&dwbpb, &dpbpb);

	FirstDataSectorDSDRel = dwbpb.fdat;
	LastDataSectorDSDRel = dwbpb.ldat;
	DataSectorCapacity = LastDataSectorDSDRel - FirstDataSectorDSDRel;

	cprintf("\nDSD Relative Sector Locations:\n");
	cprintf("First data sector: %8ld (0x%06lX)\n", 
		FirstDataSectorDSDRel, FirstDataSectorDSDRel);
	cprintf("Last data sector:  %8ld (0x%06lX)\n", 
		LastDataSectorDSDRel, LastDataSectorDSDRel);
	cprintf("Data capacity:     %8ld sectors, %ld bytes\n", 
		DataSectorCapacity, DataSectorCapacity * PICO_SECTOR_SIZE);
	
	return 0;

	}	//____ GetFirstLastSectors() ____//


/******************************************************************************\
**	DumpDataSectors
\******************************************************************************/
char *DumpDataSectors(CmdInfoPtr cip)
	{
	enum			{ dd, first, last };
	short			err;
	short			logdrv = DSDGetCurrentDrive();
	static long		sectorStartDataRel = 0;
	long			sectorEndDataRel;
	long			sectorStartVolRel, sectorEndVolRel;
	char			rdbuf[ATA_SECTOR_SIZE];

	if (DataSectorCapacity == 0)	// make sure we've got something to work with
		GetFirstLastSectors(cip);

	if (cip->argc > first && cip->argv[first].isval)		// at least one
		{
		if (cip->argc > (first + 1) && cip->argv[first + 1].isval)	// both
			{
			if (! CmdExpectRange(cip, first, &sectorStartDataRel, &sectorEndDataRel))
				return CmdErrf(cip, cmdInvalidRange, CmdInvalidRange);
			sectorStartVolRel = sectorStartDataRel + FirstDataSectorDSDRel;
			sectorEndVolRel = sectorEndDataRel + FirstDataSectorDSDRel;
			}
		else
			{
			if (! CmdExpectValue(cip, first, &sectorStartDataRel))
				return CmdErrf(cip, cmdInvalidRange, CmdInvalidRange);
			sectorStartVolRel = sectorStartDataRel + FirstDataSectorDSDRel;
			sectorEndVolRel = sectorStartVolRel;
			}
		}
	else	// just one sector
		{
		sectorStartVolRel = sectorStartDataRel + FirstDataSectorDSDRel;
		sectorEndVolRel = sectorStartVolRel;
		}

//	for ( ; sectorStartDataRel <= sectorEndDataRel; 
//			sectorStartDataRel++, sectorStartVolRel++)
	for ( ; sectorStartVolRel <= sectorEndVolRel; 
			sectorStartDataRel++, sectorStartVolRel++)
		{
		
		cprintf("\n\n%c: Sector %ld [0x%lX] (VolRel 0x%lX)", 
			logdrv + 'A', sectorStartDataRel, sectorStartDataRel, sectorStartVolRel);
		if (sectorStartDataRel > LastDataSectorDSDRel)
			return "Invalid sector requested";
		
		if ((err = DSDReadSectors(logdrv, sectorStartVolRel, rdbuf, 1)) != 0)
			cprintf("\nRead error %u [0x%X] @ sector %ld [0x%lX] (VolRel 0x%lX)\n",
				err, err, sectorStartDataRel, sectorStartDataRel, sectorStartVolRel);
		if (chexdump(rdbuf, sectorStartDataRel * ATA_SECTOR_SIZE, 2, ATA_SECTOR_SIZE))
			return CmdErrf(cip, cmdCancelled, CmdCancelled);
		
		}

	return 0;

	}	//____ DumpDataSectors() ____//


/******************************************************************************\
**	PrepForFakeFile
\******************************************************************************/
char *PrepForFakeFile(CmdInfoPtr cip)
	{
	short		err;
	short		logdrv = DSDGetCurrentDrive();
	DOSWorkingBootParamBlock		dwbpb;
	DOSPackedBootParamBlock			dpbpb;
	static char *PrephelpText =		// CMD ABBREV = "drv: [/V[:label]] [/Q]"
		{
		"\n"
		"Formats a card for use with direct sector logger\n"

		"PREP filename maxbytes\n"
		"\n"
		};
	enum		{ prep, filename, maxsize };
	short		fd = 0;
	long		sought;
	long		allofit;
	
	DosSwitch	QMsw = { "/", '?', 0, 0 };		// help

	if ((err = DBRGetBootParamBlock(logdrv, &dpbpb)) != 0)
		return CmdErrf(cip, err, CmdDriveError);
	DBRUnpackParamBlock(&dwbpb, &dpbpb);
	allofit = (dwbpb.ldat - dwbpb.fdat) * PICO_SECTOR_SIZE;

	DSDResetOptimizations(-1);	// reset all drives

	CmdExtractCIDosSwitches(cip, "?", &QMsw);
	
// HELP SWITCH SELECTED (common format to many commands)
	if (QMsw.pos)
		{
		cprintf(PrephelpText);
		return 0;
		}

//	PicoZOOM won't be active in our simple example, but this could be
//		copied to a user's application where a currently PicoZOOM'd
//		card could screw up the formatting.
	if (PZCacheActive(SHRT_MIN))	// if any card is PicoZOOMing
		return CmdErrf(cip, cmdCantWithPicoZOOM, CmdCantWithPicoZOOM);

	cprintf("\nPREPing this drive will erase all of its data!\n");
	if (! QRconfirm("Are you sure", false, true))
		return CmdErrf(cip, cmdCancelled, CmdCancelled);

//	Make sure the card is formatted at the lowest levels with known and
//		recreatable PicoDOS data structures. This ensures the highest
//		likelyhood of recoverability in the event of the worst case
//		disasters.
	execstr("fdisk /p /f /q");

//	Remount the card after the fdisk to make sure PicoDOS uses the 
//		proper drive geometry tables. 
	execstr("mount cf");

//	Erase every data sector to known 0xFF state
//		The built-in format command uses a slow, brute force method that
//		writes one sector at a time and doesn't pre-read to omit unnecessary
//		write for already erased sectors. This is a good candidate for
//		replacement with a better routine using allocated memory for
//		multi-sector reads and writes to pre-qualify and take advantage
//		of known max capacity limitations and better I/O speeds.
//		For now though...
	execstr("format /e");		// erase every sector

//	Create the fake data file with the specified size
	cprintf("\nCreating file %s with fake length of %ld bytes\n", cip->argv[filename].str, allofit);
	cprintf("Be patient, this takes about 1s/MB...\n");
	
	PZCacheSetup('C'-'A', calloc, free);
	if ((fd = open(cip->argv[filename].str, O_WRONLY | O_CREAT)) == 0)
		{
		cprintf("\nError %d opening %s\n",
			errno, cip->argv[filename].str);
		return (char *) -1;
		}

	sought = lseek(fd, allofit, SEEK_SET);
	if (sought != allofit)
		{
		cprintf("\nError %ld seeking %ld\n",
			sought, allofit);
		close (fd);
		return (char *) -1;
		}
	close (fd);
	PZCacheRelease('C'-'A');
	cprintf("\nComplete\n");
	execstr("dir");
	
	return 0;

	}	//____ PrepForFakeFile() ____//


/******************************************************************************\
**	SectorTimeCmd
\******************************************************************************/
char *SectorTimeCmd(CmdInfoPtr cip)
	{
	enum	{ st, count };

	long		repeat = 1;
	long		sector = 1;
	short		err;
	RTCTimer	tmtest;
	long		us;
	float		msf;
	ATADvr		iodvr = CFGetDriver();
	char		buffer[ATA_SECTOR_SIZE];
	
	cprintf("\n%s\n", cip->argv[0].str);	// just prints the command string

	RTCElapsedTimerSetup(&tmtest);
	err = ATAWriteSectors(iodvr, sector, buffer, 1);
	us = RTCElapsedTime(&tmtest);
	msf = us / 1000.0;
	printf("\nWrote %ld sectors in %1.3f us, err = %d [0x%X]\n",
		repeat, msf, err, err);

	return 0;

	}	//____ SectorTimeCmd() ____//



/******************************************************************************\
**	TemplateCmd		Copy and paste this for a skeleton CMD function
\******************************************************************************/
char *TemplateCmd(CmdInfoPtr cip)
	{
	enum	{ cmd, arg1, arg2, arg3, arg4 };

	cprintf("\n%s\n", cip->argv[cmd].str);	// just prints the command string

	return 0;

	}	//____ TemplateCmd() ____//


/******************************************************************************\
**	StartAD
\******************************************************************************/
char *StartAD(CmdInfoPtr cip)
	{
	short		err;
	short		logdrv = DSDGetCurrentDrive();
	DOSWorkingBootParamBlock		dwbpb;
	DOSPackedBootParamBlock			dpbpb;
	ulong Start, End;
	enum	{ cmd, arg1, arg2, arg3, arg4 };

	cprintf("\n%s\n", cip->argv[cmd].str);	// just prints the command string

	if ((err = DBRGetBootParamBlock(logdrv, &dpbpb)) != 0)
		return CmdErrf(cip, err, CmdDriveError);
	DBRUnpackParamBlock(&dwbpb, &dpbpb);

	Start = dwbpb.fdat;
	End = dwbpb.ldat;


	FastAD(Start,End);

	return 0;

	}	//____ SimpleCmd() ____//


/******************************************************************************\
**	ArgsCmd			a commmand working the arguments
\******************************************************************************/
char *ArgsCmd(CmdInfoPtr cip)
	{
	short	i;
	
	cprintf("\nArgsCmd\n");
	
	cprintf("argc = %d\n", cip->argc);
	for (i = 0; i < cip->argc; i++)
		{
		cprintf("%d -> \'%s\'\n", i, cip->argv[i].str);
		if (cip->argv[i].isval)
			cprintf("   = %ld {0x%lX} %s\n", cip->argv[i].value, cip->argv[i].value, 
				cip->argv[i].isrange ? " {Range}" : "");
		}

	return 0;

	}	//____ ArgsCmd() ____//


/******************************************************************************\
**	SwitchesCmd			a commmand demonstrating switches
**	
**	This example uses the built-in PicoDOS CmdExtractCIDosSwitches() function
**	to search for and identify position of dos switches in the command line
**	arguments. The companion function CmdExtractAVDosSwitches uses the same
**	mechanics to parse standard argc, argv command lines from applications.
**	
**	Switches take the form of -S[v] or /S[v] 
**		Where [v] is an optional value and the skpspc field decides
**		whether we allow intervening spaces.
**	
**	Example Usage:
**		Expecting command line in the form of:
**			SWITCH ARGSTR1 /M E100 /N44AB /Q +R /S /Y 600 /Z1.3
**		The /P and /Q switches do not accept arguments
**		The +R and +S switches do not accept arguments and must be prefaced with +
**		The /M and /N switches accepts hex arguments but not with spaces
**		The /Y and /Z accept decimal arguments and allow spaces
**	Use:
**		DosSwitch	psw = { "/-", 'P', 0, 0 };
**		DosSwitch	qsw = { "/-", 'Q', 0, 0 };
**		DosSwitch	rsw = { "+",  'R', 0, 0 };
**		DosSwitch	ssw = { "+",  'S', 0, 0 };
**		DosSwitch	msw = { "/-", 'M', 0, "%lx", false };
**		DosSwitch	nsw = { "/-", 'N', 0, "%lx", false };
**		DosSwitch	ysw = { "/-", 'Y', 0, "%ld", true };
**		DosSwitch	zsw = { "/-", 'Z', 0, "%f", true };
**
**	CmdExtractCIDosSwitches(cip, "PQRSMNYZ", &psw, &qsw, &msw, &nsw, &ysw, &zsw);
**		Note that "PQRSMNYZ" could just as well have been "12345678"
**		since it just informs the function of the number of switches.
**		
**	On Return: (with the example line above and below)
**			SWITCH ARGSTR1 /M E100 /N44AB /Q +R /S /Y 600 /Z1.3
**	ARGV    0       1       2  3    4      5  6  7   8		
**		psw = { "/-", 'P', 0, "NULL", 0, 0, 0 [0x0] [0.000000]
**		qsw = { "/-", 'Q', 5, "NULL", 0, 0, 0 [0x0] [0.000000]
**		rsw = { "+",  'R', 6, "NULL", 0, 0, 0 [0x0] [0.000000]
**		ssw = { "+",  'S', 0, "NULL", 0, 0, 0 [0x0] [0.000000]
**		msw = { "/-", 'M', 2, "%lx", 0, 0, 0 [0x0] [0.000000]
**		nsw = { "/-", 'N', 4, "%lx", 0, 1, 17579 [0x44AB] [0.000000]
**		ysw = { "/-", 'Y', 8, "%ld", 1, 1, 600 [0x258] [0.000000]
**		zsw = { "/-", 'Z', 10, "%f", 1, 1, 1067869798 [0x3FA66666] [1.300000]
**	
**	Copy the following line and paste it into the command for a quick test:
**			SWITCH ARGSTR1 /M E100 /N44AB /Q +R /S /Y 600 /Z1.3
**	
\******************************************************************************/
char *SwitchesCmd(CmdInfoPtr cip)
	{
	static char *teststr = "SWITCH ARGSTR1 /M E100 /N44AB /Q +R /S /Y 600 /Z1.3";
	DosSwitch	psw = { "/-", 'P', 0, 0 };
	DosSwitch	qsw = { "/-", 'Q', 0, 0 };
	DosSwitch	rsw = { "+",  'R', 0, 0 };
	DosSwitch	ssw = { "+",  'S', 0, 0 };
	DosSwitch	msw = { "/-", 'M', 0, "%lx", false };
	DosSwitch	nsw = { "/-", 'N', 0, "%lx", false };
	DosSwitch	ysw = { "/-", 'Y', 0, "%ld", true };
	DosSwitch	zsw = { "/-", 'Z', 0, "%f", true };
	
	if (cip->argc == 1)		// no arguments
		{
		printf("\nNo arguments passed, using default test string:\n%s\n",
			teststr);
		CmdExecf(cip, teststr);
		return 0;
		}
	
	printf("\nBefore:\n");
	printf("psw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n", 
		psw.swset, psw.idch, psw.pos, psw.scfmt ? psw.scfmt : "NULL", 
		psw.skpspc, psw.hasv, psw.lv, psw.lv, psw.fv);
	printf("qsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		qsw.swset, qsw.idch, qsw.pos, qsw.scfmt ? qsw.scfmt : "NULL", 
		qsw.skpspc, qsw.hasv, qsw.lv, qsw.lv, qsw.fv);
	printf("rsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		rsw.swset, rsw.idch, rsw.pos, rsw.scfmt ? rsw.scfmt : "NULL", 
		rsw.skpspc, rsw.hasv, rsw.lv, rsw.lv, rsw.fv);
	printf("ssw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		ssw.swset, ssw.idch, ssw.pos, ssw.scfmt ? ssw.scfmt : "NULL", 
		ssw.skpspc, ssw.hasv, ssw.lv, ssw.lv, ssw.fv);
	printf("msw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		msw.swset, msw.idch, msw.pos, msw.scfmt ? msw.scfmt : "NULL", 
		msw.skpspc, msw.hasv, msw.lv, msw.lv, msw.fv);
	printf("nsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		nsw.swset, nsw.idch, nsw.pos, nsw.scfmt ? nsw.scfmt : "NULL", 
		nsw.skpspc, nsw.hasv, nsw.lv, nsw.lv, nsw.fv);
	printf("ysw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		ysw.swset, ysw.idch, ysw.pos, ysw.scfmt ? ysw.scfmt : "NULL", 
		ysw.skpspc, ysw.hasv, ysw.lv, ysw.lv, ysw.fv);
	printf("zsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		zsw.swset, zsw.idch, zsw.pos, zsw.scfmt ? zsw.scfmt : "NULL", 
		zsw.skpspc, zsw.hasv, zsw.lv, zsw.lv, zsw.fv);

	CmdExtractCIDosSwitches(cip, "12345678", 
		&psw, &qsw, &rsw, &ssw, &msw, &nsw, &ysw, &zsw);

	printf("\nAfter\n");
	printf("psw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n", 
		psw.swset, psw.idch, psw.pos, psw.scfmt ? psw.scfmt : "NULL", 
		psw.skpspc, psw.hasv, psw.lv, psw.lv, psw.fv);
	printf("qsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		qsw.swset, qsw.idch, qsw.pos, qsw.scfmt ? qsw.scfmt : "NULL", 
		qsw.skpspc, qsw.hasv, qsw.lv, qsw.lv, qsw.fv);
	printf("rsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		rsw.swset, rsw.idch, rsw.pos, rsw.scfmt ? rsw.scfmt : "NULL", 
		rsw.skpspc, rsw.hasv, rsw.lv, rsw.lv, rsw.fv);
	printf("ssw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		ssw.swset, ssw.idch, ssw.pos, ssw.scfmt ? ssw.scfmt : "NULL", 
		ssw.skpspc, ssw.hasv, ssw.lv, ssw.lv, ssw.fv);
	printf("msw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		msw.swset, msw.idch, msw.pos, msw.scfmt ? msw.scfmt : "NULL", 
		msw.skpspc, msw.hasv, msw.lv, msw.lv, msw.fv);
	printf("nsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		nsw.swset, nsw.idch, nsw.pos, nsw.scfmt ? nsw.scfmt : "NULL", 
		nsw.skpspc, nsw.hasv, nsw.lv, nsw.lv, nsw.fv);
	printf("ysw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		ysw.swset, ysw.idch, ysw.pos, ysw.scfmt ? ysw.scfmt : "NULL", 
		ysw.skpspc, ysw.hasv, ysw.lv, ysw.lv, ysw.fv);
	printf("zsw = { \"%s\", '%c', %d, \"%s\", %d, %d, %ld [0x%lX] [%f]\n",
		zsw.swset, zsw.idch, zsw.pos, zsw.scfmt ? zsw.scfmt : "NULL", 
		zsw.skpspc, zsw.hasv, zsw.lv, zsw.lv, zsw.fv);

	return 0;

	}	//____ SwitchesCmd() ____//


/******************************************************************************\
**	PicoCmd			a way back to real PicoDOS
\******************************************************************************/
char *PicoCmd(CmdInfoPtr cip)
	{
	enum	{ cmd, val };
	short	exitval = 0;
	static char *PicoCmdText =
		{
		"\n"
		"Exits topico session, optionally returns value of first arg.\n"

		"EXIT returnVal\n"
		"\n"
		};
	DosSwitch	QMsw = { "/", '?', 0, 0 };		// help

	CmdExtractCIDosSwitches(cip, "?", &QMsw);

// HELP SWITCH SELECTED (common format to many commands)
	if (QMsw.pos)
		{
		cprintf(PicoCmdText);
		return 0;
		}

	if (cip->argc > val && cip->argv[val].isval)
		exitval = cip->argv[val].value;
	
	// restore standard PicoDOS prompt
	execstr("PROMPT %s", VEEFetchStr(SYS_PROMPT_VEENAME, SYS_PROMPT_DEFAULT));
	cprintf("\nBye...\n");
	exit(exitval);

	return 0;

	}	//____ PicoCmd() ____//

