/******************************************************************************\
**	FasterAD.c		Fast A-D but writting to the Card
**	(based on FastAD.c
**
**	First release:			Friday, June 26, 1998
**	Latest release:			Thursday, April 4, 2002
*****************************************************************************
**	
**	Licensed by:	Persistor Instruments Inc. for the Peristor CF2
**	info@persistor.com - http://www.persistor.com
**	
*****************************************************************************
**	
**	Developed by:	John H. Godley Persistor Instruments
**	jhgodley@persistor.com - http://www.persistor.com
**	Copyright (C) 1996-2002  Persistor Instruments.	All rights reserved.
**
**	Modification by Thomas P. Sullivan
**	tpsully@persistor.com
**	04/04/02
**	
*****************************************************************************
**	
** Copyright and License Information
** 
** Persistor Instruments Inc. (hereafter, PII) grants you (hereafter,
** Licensee) a non-exclusive, non-transferable license to use the software
** source code contained in this single source file with hardware products
** sold by PII. Licensee may distribute binary derivative works using this
** software and running on PII hardware products to third parties without
** fee or other restrictions.
** 
** PII MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
** SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
** OR NON-INFRINGEMENT. PII SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
** LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THE SOFTWARE OR
** ITS DERIVATIVES.
** 
** By using or copying this Software, Licensee agrees to abide by the
** copyright law and all other applicable laws of the U.S. including, but
** not limited to, export control laws, and the terms of this license. PII
** shall have the right to terminate this license immediately by written
** notice upon Licensee's breach of, or non-compliance with, any of its
** terms. Licensee may be held legally responsible for any copyright
** infringement or damages resulting from Licensee's failure to abide by
** the terms of this license. 
**
\******************************************************************************/

#define DEBUG			// comment this out to turn off diagnostics
#include	<cfxbios.h>		// Persistor CF1 BIOS and I/O Definitions
#include	<cfxpico.h>		// Persistor CF1 PicoDOS Definitions
#include	<cfxAD.h>		// Generic SPI A-D QPB Driver for CF1

// Place non-PicoDAQ A-D definitions here - before including <ADExamples.h>
#define	ADSLOT	NMPCS3			// The QPB slot number (0..14)
#define	ADTYPE	ADisADS8344		// The A-D selector from <cf1AD.h>
#define	VREF	3.3				// A-D reference voltage
#define	PRCPLG

#include	<ADExamples.h>	// Common efinitions for the A-D Examples

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#define	FCHAN		0					// first channel
#define	NCHAN		8					// number of channels
#define	FASTPITRATE	PIT2kHz				// 3=3.3khz - periodic interrupt rate
#define	SYSCLK		16000				// choose: 160 to 32000 (kHz)
#define	WTMODE		nsStdSmallBusAdj	// choose: nsMotoSpecAdj or nsStdSmallBusAdj

#define AD_RAW_DATA_BUF_SIZE	65536L	// whatever is appropriate
typedef struct { short	adata[NCHAN]; }	RawData;	// allows structure copy
//extern RawData	*ADDataBuf;				// dynamically allocated at run time
 RawData	*ADDataBuf;				// dynamically allocated at run time

//extern ushort	ADRawHead, ADRawTail, ADRawFollower;	// head and tail indexes
 ushort	ADRawHead, ADRawTail, ADRawFollower;	// head and tail indexes

//extern CFxAD	adbuf, *ad;
 CFxAD	adbuf, *ad;

IEV_C_PROTO(ADTimingRuptHandler2);
IEV_C_PROTO(ADSamplingRuptHandler2);
extern IEV_C_FUNCT(ADSamplingRuptHandler);


#define AD_PPB_DATA_BUF_SIZE	65536L	// whatever is appropriate
void		*RAMppb;				// dynamically allocated RAM ping-pong buffer (big)


#define ADSTOREWORDS	0
#define MAX146_HIBYTE	1
#define MAX146_LOBYTE	2
#define ADS8344_HIBYTE	3
#define ADS8344_LOBYTE	4
#define ADSTORETYPE		ADSTOREWORDS	// choose one from the above list



/******************************************************************************\
**	main (changed to function for MyPico application  --tps)
\******************************************************************************/
int FastAD(ulong startsect, ulong endsect);
int FastAD(ulong startsect, ulong endsect)
	{
//	short		i, j;
	bool		uni = true;		// true for unipolar, false for bipolar
	bool		sgl = true;		// true for single-ended, false for differential
	float		vref = VREF;
	ulong		lStartSector = startsect;
	ulong		lEndSector = endsect;
	ulong		lNextSector = startsect;
	short		logdrv = DSDGetCurrentDrive();
	bool		stopped = false;
	
	char		*RAMPingPongBuf;		// ping-pong buffer, never directly accessed


	cprintf("\n\nStart sector = %lu\n",startsect);
	cprintf("Start sector = %lu\n",endsect);
/*
	do {
	QRulong("\nEnter the starting sector number: ", "%lu", true, &lStartSector, startsect, endsect);	//0x200000 is good for a Gigabyte
	QRulong("\nEnter the ending   sector number: ", "%lu", true, &lEndSector, startsect, endsect);	//0x200000 is good for a Gigabyte
	} while(lStartSector>lEndSector);
	cprintf("\n\n");
*/

	if ((RAMPingPongBuf = calloc(AD_PPB_DATA_BUF_SIZE, 1)) != 0)
		if ((RAMppb = PPBOpen(AD_PPB_DATA_BUF_SIZE, RAMPingPongBuf, 0, 0, 0)) != 0)
			;	// we're ok
		else	
		{
		cprintf("Couldn't allocate the raw data buffer!\n");
		return -1;
		}

	CSSetSysAccessSpeeds(nsFlashStd, nsRAMStd, nsCFStd, WTMODE);
	TMGSetSpeed(SYSCLK);

  #ifdef DEBUG
	PIOSet(25);		// Use this group of pins to monitor
	PIOSet(26);		// the acquisition process with an
	PIOSet(27);		// oscilloscope to spot overruns
  #endif
	// Initialize QPB to accept our A-D with its QSPI connection.
	ad = CFxADInit(&adbuf, ADSLOT, ADInitFunction);
	if (! CFxADLock(ad))	// lock it down, we want to own the QSPI
		{
		printf("\nCouldn't lock and own A-D with QSPI\n");
		return -1;
		}

	ADRawFollower = ADRawHead = ADRawTail = 0;	// for first dummy reading to set things up
	
	CFxADSampleBlock(ad, FCHAN, NCHAN, &ADSamplingRuptHandler2, uni, sgl, false);

	PITSet100usPeriod(PITOff);	// disable timer
	PITRemoveChore(0);			// get rid of all current chores
	IEVInsertCFunct(&ADTimingRuptHandler2, pitVector);	// replacement fast routine

	cprintf("\nHit a key to start..."); fflush(stdout);
	while(!kbhit())
	;
	cprintf("... Sampling type '.' (period) to stop...\n\n"); fflush(stdout);

	ADRawFollower = ADRawHead = 0;		// reset start pointer
	ADRawTail = AD_RAW_DATA_BUF_SIZE / sizeof(RawData);

	PITSet100usPeriod(FASTPITRATE);		// start the engine ...
	for (lNextSector = lStartSector; lNextSector < lEndSector; )
//	while (lNextSector < lEndSector)		// and go until we fill up
		{	// keep this in brackets for the DBG macro
		short	err;
		long	avail;
		void	*ppbuf;
		vushort	saveSR;

		if (kbhit())
			if (cgetc() == '.')
				{
				stopped = true;
				PITSet100usPeriod(PITOff);		// stop sampling
				PPBFlush(RAMppb);	// force it conclude
				}


	//  ************************************************************************
	// NOW SEE IF THAT PING-PONG'D THE BUFFER AND IT'S TIME TO WRITE TO THE CARD
	//  ************************************************************************
		saveSR = IEVSaveSRThenDisable();
		avail = PPBCheckRdAvail(RAMppb);
		IEVRestoreSavedSR(saveSR);
		if (avail != 0)
			{
			DBG( PinSet(26); )	// low activity may indicate trouble
			ppbuf = PPBGetMemBuf(RAMppb, &avail, true);	// and flush it
			DBG( PinClear(26); )	// low activity may indicate trouble
			avail /= ATA_SECTOR_SIZE;	// bytes to sectors
			if ((err = DSDWriteSectors(logdrv, lNextSector, ppbuf, avail)) != 0)
				cprintf("\n### DSDWriteSectors error %d ###\n", err);
			lNextSector += avail;
			}

		if (stopped)
			{
			cprintf("\nRecorded %lu sectors or %lu bytes of data\n\n",lNextSector-lStartSector,(lNextSector-lStartSector)*ATA_SECTOR_SIZE);
			break;
			}
		}

	PITSet100usPeriod(PITOff);		// stop sampling

	printf("complete \n");fflush(stdout);

	return 0;
	
	}	//____ main() ____//


/******************************************************************************\
**	ADTimingRuptHandler		Initiate conversion
**	
**	This interrupt has a priority level of six, which makes it the highest 
**	priority task in the system.
**	
**	This starts the QSPI which generates a follow up interrupt in about 10uS
**	per channel sampled at 16MHz.
\******************************************************************************/
IEV_C_FUNCT(ADTimingRuptHandler2)	// implied (IEVStack *ievstack:__a0) parameter
	{
	#pragma unused(ievstack)

	DBG( PinClear(25); )
	QPBRepeatAsync();	// starts the QSPI running with previous parameters
	DBG( PinSet(25); )

	}	//____ ADTimingRuptHandler() ____//


/******************************************************************************\
**	ADSamplingRuptHandler		Move raw QPSI data to main buffer
**	
\******************************************************************************/
IEV_C_FUNCT(ADSamplingRuptHandler2)	// implied (IEVStack *ievstack:__a0) parameter
	{
	#pragma unused(ievstack)
	static RawData		tempbuf;
	static uchar		bytebuf[NCHAN];
	static long			actual;
	static short		i;

	DBG( PinClear(27); )
	CPUWriteInterruptMask(SIM_PITR_DEF_IPL);
	QPBClearInterrupt();

// FIRST GRAB THE QSPI DATA BEFORE IT GETS OVERWRITTEN
	tempbuf = * (RawData *) CFxADQueueToArray(ad, (void *) QRR, NCHAN);


#if (ADSTORETYPE == MAX146_HIBYTE)
	for (i = 0; i < NCHAN; i++)
		bytebuf[i] = tempbuf.adata[i] >> 7;
	actual = PPBWrite(RAMppb, bytebuf, NCHAN);


#elif  (ADSTORETYPE == MAX146_LOBYTE)
	for (i = 0; i < NCHAN; i++)
		bytebuf[i] = tempbuf.adata[i] >> 3;
	actual = PPBWrite(RAMppb, bytebuf, NCHAN);


#elif (ADSTORETYPE == ADS8344_HIBYTE)
	for (i = 0; i < NCHAN; i++)
		bytebuf[i] = tempbuf.adata[i] >> 8;
	actual = PPBWrite(RAMppb, bytebuf, NCHAN);


#elif  (ADSTORETYPE == ADS8344_LOBYTE)
	for (i = 0; i < NCHAN; i++)
		bytebuf[i] = tempbuf.adata[i];	// effective & 0xFF
	actual = PPBWrite(RAMppb, bytebuf, NCHAN);

#else	// store 16-bit words
	
	actual = PPBWrite(RAMppb, tempbuf.adata, NCHAN * 2) / 2;

#endif

	if (actual != NCHAN)
		{
		cprintf("\n### PPB overrun ###\n");
		
		}

	DBG( PinSet(27); )

	}	//____ ADSamplingRuptHandler() ____//


