BEGIN	{
	  lat_avg = 0.0; long_avg = 0.0;
	  lat_err = 0.0; long_err = 0.0;
	  true_lat = (36 * 60) + 37.115123; 
	  true_long = (121 * 60) + 54.336191;
	  lat_min = true_lat; lat_max = true_lat; 
	  long_min = true_long; long_max = true_long;
	  recs = 0; reported_error = 0;
	  min_to_meters = 1852;
	  cos_true_lat = .802644;
	}

((! /^#/ ) && ($1 > 89.0) && ($1 < 98.0)) {
	  recs++;
	  lat = $2 * 60.0; lat_avg += lat;
	  long = $3 * 60.0; long_avg += long;
	  reported_error += $4;
	  if ( lat < lat_min) lat_min = lat;
	  if ( lat > lat_max) lat_max = lat;
	  if ( long < long_min) long_min = long;
	  if ( long > long_max) long_max = long;
	  lat = (lat - true_lat) * min_to_meters ; 
	  lat_err += (lat * lat);
	  long = (long - true_long) * min_to_meters * cos_true_lat;
	  long_err += (long * long);
	  error = sqrt((lat * lat) + (long * long));
	  err_index = int(error / 10) + 1;
	  if (err_index > 10)
	      err_index = int(error / 100) + 10;
	  if (err_index > 20)
	      err_index = 20;
	  err_no[err_index]++;
	}

END	{ lat_avg /= recs; long_avg /= recs;
	  printf("File %s, GPS data points = %d\n", FILENAME, recs);
	  printf( "Avg Lat %d %7.4f', Long %d %7.4f'\n", \
		int(lat_avg/60), lat_avg % 60, \
		int(long_avg/60), long_avg % 60 );
	  printf( "True Lat %d %7.4f', Long %d %7.4f\n", \
		int(true_lat/60), true_lat % 60, \
		int(true_long/60), true_long % 60 );
	  printf( "Std Dev Lat %d, Long %d  Reported error %d (meters)\n", \
		  sqrt(lat_err/(recs-1)), sqrt(long_err/(recs-1)), \
		  reported_error/recs );
	  printf( "Max Lat %d %5.2f', Min Lat %d %5.2f'\n", int(lat_max/60), \
		  lat_max % 60, int(lat_min/60), lat_min % 60 );
	  printf( "Max Long %d %5.2f', Min Long %d %5.2f'\n", \
		  int(long_max/60), long_max % 60, int(long_min/60), \
		  long_min % 60 );

	  for ( i = 1; i < 10; i++ )
	      printf("Err < %3d m = %d\n", i * 10, err_no[i]);
	  for ( i = 10; i < 20; i++ )
	      printf("Err < %3d m = %d\n", 100 * (i-9), err_no[i]);
	  printf("Err > 1 km = %d\n", err_no[20]);
	}
