#ifndef __EXCHANGE_H
#define __EXCHANGE_H

//	Prototypes
bool ExchangeGeneric(QPB *ptrQPBDev, ushort *uCmd, ushort unCount, ushort *data);


//	Used when you are decoding PCS0-PCS4 (or some part of it) to extend the
//	chip select range.  If you are doing something simple like connecting an
//	SPI device to a PCS signal then just use a Non-Multiplexed Chip Select
//	like NMPCS0 for PCS0.

//	If you are decoding, say, all 4 chip select lines then use a MultiPlexed
//	Chip Select.  NOTE: MPCS15 means no device selected so therefore, decoding
//	the chip selects in this way will only yield 15 total chip selects and
//	not 16 (NOTE: If you are using chip selects without multiplexing, then
//	you do not need or have to care about MPCSx but only about NMPCS0).
enum  {MPCS0 = 0, MPCS1 = 1, MPCS2 = 2, MPCS3 = 3, MPCS4 = 4, MPCS5 = 5, MPCS6 = 6, MPCS8 = 8, MPCS9 = 9, MPCS10 = 10, MPCS11 = 11, MPCS12 = 12, MPCS13 = 13, MPCS14 = 14};



#endif