/****************************************************************************/
/* Copyright (C) 2001 MBARI                                                 */
/* Author: Kent Headley                                                     */
/****************************************************************************/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/

#include <stdio.h>			/* Standard I/O			    */
#include <stdlib.h>			/* For exit()			    */
#include <mbariTypes.h>			/* MBARI type definitions	    */
#include <mbariConst.h>			/* MBARI constants		    */
#include <time.h>			/* Time				    */
#include <math.h>
#include <ctype.h>
#include <string.h>

#define LOCAL 0
#define EQPAC 1

Extern char	*optarg;		/* Option argument from getopt()    */
Extern Int	optind;			/* Option index from getopt()	    */
#ifdef WIN32
Extern Int	getopt( Int argc, char *const *argv, const char *fmt );
#endif

int location=LOCAL;
int firstarg;

MBool	process_command_line ( Int argc, char **argv );
Void	use_msg( char *s );

main(argc,argv)
int argc;
char *argv[];
{
int i,iday,iyear;
double year,day,hour,min,sec;
double ip;
double days_per_year;

if ( !process_command_line(argc, argv) )
  {
    use_msg(argv[0]);
    exit( 1 );
  }

if(location == EQPAC)
  for(i=firstarg;i<argc;i++){
    if (sscanf(argv[i],"%lf",&year)>=1){
      if(year<0)year*=(-1.0);
      modf(year,&ip);
      iyear=(int)ip;
      days_per_year=(iyear%4==0)?366:365;
      day  =(modf(year,&ip))*(days_per_year);
      year=ip;
      hour =(modf(day,&ip))*24;
      day=ip;
      min  =(modf(hour,&ip))*60;
      hour=ip;
      sec  =(modf(min,&ip))*60;
      min=ip;
      printf("%3.0lf %02.0lf:%02.0lf:%03.1lf\n",day,hour,min,sec);
    }
  }/*end for...EQPAC*/

if(location == LOCAL)
  for(i=firstarg;i<argc;i++){
    if (sscanf(argv[i],"%lf",&day)>=1){
      if(day<0)day*=(-1.0);
      modf(day,&ip);
      iday=(int)ip;
      hour =(modf(day,&ip))*24;
      day=ip;
      min  =(modf(hour,&ip))*60;
      hour=ip;
      sec  =(modf(min,&ip))*60;
      min=ip;
      printf("%3.0lf %02.0lf:%02.0lf:%03.1lf\n",day,hour,min,sec);
    }
  }/*end for...LOCAL*/
return 0;
}

/************************************************************************/
/* Function : process_command_line					*/
/* Purpose  : Read the arguments from the command line			*/
/* Inputs   : argc, argv from main() routine				*/
/* Outputs  : TRUE if arguments OK, else FALSE				*/
/************************************************************************/
	MBool
process_command_line ( argc, argv )
Int argc;
char **argv;
{
    Int		i;

    location = LOCAL;

    while ( (i = getopt(argc, argv, "el")) != EOF )
	switch( i )
	{
	  case 'e':
	    location = EQPAC;
	    firstarg=2;
	    break;

	  case 'l':
	    location = LOCAL;
	    firstarg=2;
	    break;

	  default:
	    return( FALSE );
	}

    return( TRUE );

} /* process_command_line() */

/************************************************************************/
/* Function : use_msg							*/
/* Purpose  : Print Usage Message					*/
/* Inputs   : Name of program						*/
/* Outputs  : None							*/
/************************************************************************/
	Void
use_msg( s )
char *s;
{
    fprintf( stderr,
   "Usage: %s [-e] [-l] timestamp [timestamp]...\n", s );
    fprintf( stderr, "-e EQPAC time stamp (decimal year)\n");
    fprintf( stderr, "-l LOCAL time stamp (decimal day of year)\n");

} /* use_msg() */
