/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.siam.devices.wetlabs;

import gnu.io.UnsupportedCommOperationException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.mbari.siam.core.DeviceService;
import org.mbari.siam.core.SerialPortParameters;
import org.mbari.siam.devices.wetlabs.WetLabsECO;
import org.mbari.siam.distributed.DevicePacket;
import org.mbari.siam.distributed.DeviceServiceIF;
import org.mbari.siam.distributed.Instrument;
import org.mbari.siam.distributed.NotSupportedException;
import org.mbari.siam.distributed.Safeable;
import org.mbari.siam.distributed.SensorDataPacket;
import org.mbari.siam.distributed.TimeoutException;
import org.mbari.siam.utils.StreamUtils;

public class WetLabsTriplet
extends WetLabsECO
implements Instrument,
Safeable {
    private static final long serialVersionUID = -6847732815613058691L;
    private static Logger _log4j = Logger.getLogger((Class)(class$org$mbari$siam$devices$wetlabs$WetLabsTriplet == null ? (class$org$mbari$siam$devices$wetlabs$WetLabsTriplet = WetLabsTriplet.class$("org.mbari.siam.devices.wetlabs.WetLabsTriplet")) : class$org$mbari$siam$devices$wetlabs$WetLabsTriplet));
    static final String PUCK_PROMPT = "PUCKRDY";
    static final String INSTRUMENT_MODE_CMD = "PUCKIM";
    private final DevicePacketParser devicePacketParser = new DevicePacketParser();
    static /* synthetic */ Class class$org$mbari$siam$devices$wetlabs$WetLabsTriplet;

    public WetLabsTriplet() throws RemoteException {
        this._attributes = new Attributes((DeviceServiceIF)this);
    }

    protected void doSoftBreak() throws Exception {
        int n = 0;
        while (n < 5) {
            try {
                _log4j.debug((Object)"doSoftBreak() - issue !s");
                int n2 = 0;
                while (n2 < 7) {
                    ((DeviceService)this)._toDevice.write("!".getBytes());
                    ((DeviceService)this)._toDevice.flush();
                    Thread.sleep(200L);
                    ++n2;
                }
                ((DeviceService)this)._toDevice.write("\r".getBytes());
                ((DeviceService)this)._toDevice.flush();
                int n3 = StreamUtils.readBytes((InputStream)((DeviceService)this)._fromDevice, (byte[])this._scratch, (int)0, (int)this._scratch.length, (long)3000L);
                String string = new String(this._scratch, 0, n3);
                if (string.indexOf(this.menuPrefix()) >= 0) {
                    _log4j.debug((Object)"doSoftBreak() - now in menu");
                    return;
                }
                if (string.indexOf(PUCK_PROMPT) >= 0) {
                    _log4j.debug((Object)"doSoftBreak() - got PUCK prompt - go to instrument mode");
                    this.doCommand(INSTRUMENT_MODE_CMD, this.menuPrefix());
                    _log4j.debug((Object)"doSoftBreak() - Now in menu - return");
                    return;
                }
            }
            catch (TimeoutException timeoutException) {
                _log4j.info((Object)"enterCommandMode() - no menu prompt yet");
            }
            catch (Exception exception) {
                _log4j.error((Object)("Exception " + exception));
            }
            ++n;
        }
        _log4j.error((Object)"doSoftBreak() failed");
        throw new Exception("doSoftBreak() failed");
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(((Attributes)this._attributes).baud, 8, 0, 1);
    }

    String menuPrefix() {
        return "ver FLNTU";
    }

    public org.mbari.siam.distributed.DevicePacketParser getDevicePacketParser() {
        return this.devicePacketParser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DevicePacketParser
    extends org.mbari.siam.distributed.DevicePacketParser {
        static final String CHLOROPHYLL = "Chlorophyll";
        static final String NTU1 = "NTU1";
        static final String NTU2 = "NTU2";
        static final String SUBSAMPLE_COUNT = "Samples";
        private Vector lines = new Vector();

        DevicePacketParser() {
        }

        protected void parseFields(DevicePacket devicePacket) throws NotSupportedException, Exception {
            SensorDataPacket sensorDataPacket;
            byte[] byArray;
            if (devicePacket instanceof SensorDataPacket && (byArray = (sensorDataPacket = (SensorDataPacket)devicePacket).dataBuffer()) != null) {
                String string = new String(byArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    this.lines.add(stringTokenizer.nextToken());
                }
                this.processLines();
            }
        }

        private void processLines() throws Exception {
            int n;
            int[] nArray = new int[this.lines.size()];
            int[] nArray2 = new int[this.lines.size()];
            int[] nArray3 = new int[this.lines.size()];
            int n2 = 0;
            Enumeration enumeration = this.lines.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    block10: {
                        String string2 = stringTokenizer.nextToken();
                        try {
                            switch (n) {
                                case 2: {
                                    nArray[n2] = Integer.parseInt(string2);
                                    break;
                                }
                                case 3: {
                                    nArray2[n2] = Integer.parseInt(string2);
                                    break;
                                }
                                case 4: {
                                    nArray3[n2] = Integer.parseInt(string2);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!_log4j.isDebugEnabled()) break block10;
                            _log4j.debug((Object)"Failed to parse record", (Throwable)exception);
                            exception.fillInStackTrace();
                            throw exception;
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            int n3 = 0;
            int n4 = 0;
            n = 0;
            int n5 = 0;
            while (n5 < nArray.length) {
                n3 += nArray[n5];
                n4 += nArray2[n5];
                n += nArray3[n5];
                ++n5;
            }
            int n6 = n3 / nArray.length;
            int n7 = n4 / nArray2.length;
            int n8 = n / nArray3.length;
            this.addMeasurement(CHLOROPHYLL, "Chlorophyll concentration", "counts", n6);
            this.addMeasurement(NTU1, "Nominal Transmission units #1", "counts", n7);
            this.addMeasurement(NTU2, "Nominal Transmission units #2", "counts", n8);
            this.addMeasurement(SUBSAMPLE_COUNT, "Samples per DataPacket", "samples", nArray.length);
            this.lines.clear();
        }
    }

    protected class Attributes
    extends WetLabsECO.Attributes {
        int baud = 19200;

        protected Attributes(DeviceServiceIF deviceServiceIF) {
            super(deviceServiceIF);
            this.summaryVars = new String[]{"Chlorophyll", "NTU1", "NTU2"};
        }
    }
}

