/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.siam.devices.wetlabs;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.mbari.siam.core.BaseInstrumentService;
import org.mbari.siam.core.DeviceService;
import org.mbari.siam.core.PolledInstrumentService;
import org.mbari.siam.core.SerialInstrumentPort;
import org.mbari.siam.core.SerialPortParameters;
import org.mbari.siam.distributed.DevicePacketParser;
import org.mbari.siam.distributed.DeviceServiceIF;
import org.mbari.siam.distributed.InitializeException;
import org.mbari.siam.distributed.Instrument;
import org.mbari.siam.distributed.InstrumentServiceAttributes;
import org.mbari.siam.distributed.InvalidPropertyException;
import org.mbari.siam.distributed.NotSupportedException;
import org.mbari.siam.distributed.PowerPolicy;
import org.mbari.siam.distributed.RangeException;
import org.mbari.siam.distributed.Safeable;
import org.mbari.siam.distributed.ScheduleParseException;
import org.mbari.siam.distributed.ScheduleSpecifier;
import org.mbari.siam.distributed.TimeoutException;
import org.mbari.siam.utils.StreamUtils;

public class WetLabsECO
extends PolledInstrumentService
implements Instrument,
Safeable {
    SimpleDateFormat _dateFormatter = new SimpleDateFormat("MMddyy");
    SimpleDateFormat _timeFormatter = new SimpleDateFormat("HHmmss");
    static final int MAX_SAMPLE_TRIES = 3;
    static final int MAX_COMMAND_TRIES = 3;
    static final int MAX_SAMPLE_BYTES = 100;
    static final int POWER_OFF_SEC = 60;
    static final int RESPONSE_TIME = 60000;
    static final int SAMPLE_RESPONSE_TIME = 60000;
    static final String ENABLE_LOG_CMD = "$rec 1";
    static final String DISABLE_LOG_CMD = "$rec 0";
    static final String SET_DATE_CMD = "$dat ";
    static final String SET_TIME_CMD = "$clk ";
    static final String PKTS_PER_SET_CMD = "$set ";
    static final String SAMPLES_PER_PKT_CMD = "$pkt ";
    static final String AVERAGE_COUNT_CMD = "$ave ";
    static final String PACKET_INTERVAL_CMD = "$int ";
    static final String MENU_CMD = "$mnu";
    static final String STORE_CMD = "$sto";
    static final String RUN_CMD = "$run";
    static final String DATA_SYNC = "\r\n";
    static final String RESPONSE_DONE = "done";
    byte[] _scratch = new byte[512];
    private static Logger _log4j = Logger.getLogger((Class)(class$org$mbari$siam$devices$wetlabs$WetLabsECO == null ? (class$org$mbari$siam$devices$wetlabs$WetLabsECO = WetLabsECO.class$("org.mbari.siam.devices.wetlabs.WetLabsECO")) : class$org$mbari$siam$devices$wetlabs$WetLabsECO));
    protected InputStream _blockingInputStream;
    protected Attributes _attributes = new Attributes((DeviceServiceIF)this);
    static /* synthetic */ Class class$org$mbari$siam$devices$wetlabs$WetLabsECO;

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected byte[] initPromptString() {
        return "".getBytes();
    }

    protected byte[] initSampleTerminator() {
        return this.menuPrefix().getBytes();
    }

    protected int initMaxSampleBytes() {
        return 100 * this._attributes.samplesPerPacket * this._attributes.packetsPerSet;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected PowerPolicy initInstrumentPowerPolicy() {
        return PowerPolicy.WHEN_SAMPLING;
    }

    protected PowerPolicy initCommunicationPowerPolicy() {
        return PowerPolicy.WHEN_SAMPLING;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(600000L);
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        return new SerialPortParameters(19200, 8, 0, 1);
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        if (!(((DeviceService)this)._instrumentPort instanceof SerialInstrumentPort)) {
            throw new Exception("Service needs SerialInstrumentPort");
        }
        this._blockingInputStream = ((SerialInstrumentPort)((DeviceService)this)._instrumentPort).getSerialPort().getInputStream();
        _log4j.info((Object)"Initializing...");
        try {
            this.setMaxSampleBytes(this.initMaxSampleBytes());
        }
        catch (RangeException rangeException) {
            throw new InitializeException("max sample bytes out of range");
        }
        this.setMaxSampleTries(3);
        this.setSampleTimeout(60000L);
        try {
            this.enterCommandMode();
        }
        catch (Exception exception) {
            _log4j.info((Object)"Power off for 60 sec");
            ((DeviceService)this)._instrumentPort.disconnectPower();
            this.snooze(60);
            _log4j.info((Object)"Power on instrument");
            ((DeviceService)this)._instrumentPort.connectPower();
            this.enterCommandMode();
        }
        try {
            if (((BaseInstrumentService)this)._instrumentAttributes.timeSynch) {
                this.setClock();
            }
            this.doCommand(PKTS_PER_SET_CMD + ((Attributes)((BaseInstrumentService)this)._instrumentAttributes).packetsPerSet);
            this.doCommand(SAMPLES_PER_PKT_CMD + ((Attributes)((BaseInstrumentService)this)._instrumentAttributes).samplesPerPacket);
            _log4j.debug((Object)("initalizeInstrument(): $ave " + ((Attributes)((BaseInstrumentService)this)._instrumentAttributes).averageCount));
            this.doCommand(AVERAGE_COUNT_CMD + ((Attributes)((BaseInstrumentService)this)._instrumentAttributes).averageCount);
            this.doCommand(PACKET_INTERVAL_CMD + ((Attributes)((BaseInstrumentService)this)._instrumentAttributes).packetInterval);
            if (((Attributes)((BaseInstrumentService)this)._instrumentAttributes).logEnabled) {
                this.doCommand(ENABLE_LOG_CMD);
            } else {
                this.doCommand(DISABLE_LOG_CMD);
            }
            this.doCommand(STORE_CMD, RESPONSE_DONE);
        }
        catch (Exception exception) {
            _log4j.error((Object)("initializeInstrument(): " + exception));
            throw new InitializeException(exception.getMessage());
        }
        _log4j.info((Object)"Initializing completed");
    }

    public synchronized void setClock() throws NotSupportedException {
        Date date = new Date(System.currentTimeMillis());
        try {
            this.doCommand("$dat  " + this._dateFormatter.format(date));
            _log4j.info((Object)("setClock(): $dat  " + this._dateFormatter.format(date)));
        }
        catch (Exception exception) {
            throw new NotSupportedException("error while setting date");
        }
        try {
            _log4j.debug((Object)("$clk  " + this._timeFormatter.format(date)));
            this.doCommand("$clk  " + this._timeFormatter.format(date));
            _log4j.info((Object)("setClock(): $clk  " + this._timeFormatter.format(date)));
        }
        catch (Exception exception) {
            throw new NotSupportedException("error while setting time");
        }
    }

    protected synchronized void requestSample() throws TimeoutException, Exception {
        _log4j.debug((Object)"Sampling...");
        ((DeviceService)this)._fromDevice.flush();
        this.doCommand(RUN_CMD);
    }

    protected byte[] getInstrumentStateMetadata() {
        try {
            this.enterCommandMode();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((DeviceService)this)._fromDevice.flush();
            this.doCommand(MENU_CMD);
            int n = StreamUtils.readBytes((InputStream)((DeviceService)this)._fromDevice, (byte[])this._scratch, (int)0, (int)this._scratch.length, (long)3000L);
            String string = new String(this._scratch, 0, n);
            return string.getBytes();
        }
        catch (Exception exception) {
            return exception.getMessage().getBytes();
        }
    }

    public void setClock(long l) {
    }

    protected void doCommand(String string, String string2) throws Exception {
        int n = 0;
        while (n < 3) {
            try {
                ((DeviceService)this)._fromDevice.flush();
                if (string.equals(RUN_CMD)) {
                    _log4j.info((Object)("TEST: ID=" + this.getId() + ", trigger sample at " + System.currentTimeMillis()));
                }
                ((DeviceService)this)._toDevice.write(this.mkCmd(string));
                ((DeviceService)this)._toDevice.flush();
                if (string2.length() == 0) {
                    return;
                }
                StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])string2.getBytes(), (long)5000L);
                ((DeviceService)this)._fromDevice.flush();
                return;
            }
            catch (IOException iOException) {
                _log4j.error((Object)("IOException " + iOException));
                throw new Exception("doCommand(" + string + ") - Stream I/O failure");
            }
            catch (NullPointerException nullPointerException) {
                _log4j.error((Object)("Null Pointer Exception " + nullPointerException));
                throw new Exception("doCommand(" + string + ") - Null pointer");
            }
            catch (TimeoutException timeoutException) {
                _log4j.error((Object)("Timeout Exception: " + (Object)((Object)timeoutException) + "Cmd=" + string));
            }
            catch (Exception exception) {
                _log4j.error((Object)("Exception " + exception));
            }
            ++n;
        }
        throw new Exception("doCommand(" + string + ") - Maximum retries attempted");
    }

    protected void doCommand(String string) throws Exception {
        this.doCommand(string, "");
        _log4j.debug((Object)"doCommand() - wait 2000 msec for processing");
        Thread.sleep(2000L);
    }

    protected void enterCommandMode() throws Exception {
        this.doCommand(MENU_CMD);
        try {
            StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])this.menuPrefix().getBytes(), (long)1000L);
            ((DeviceService)this)._fromDevice.flush();
            _log4j.debug((Object)"enterCommandMode() - already in command mode");
            return;
        }
        catch (Exception exception) {
            try {
                _log4j.debug((Object)"enterCommandMode() - doSoftBreak()");
                this.doSoftBreak();
                return;
            }
            catch (Exception exception2) {
                _log4j.debug((Object)"enterCommandMode() - no menu");
                throw new Exception("Couldn't get to menu mode");
            }
        }
    }

    protected void doSoftBreak() throws Exception {
        int n = 0;
        while (n < 5) {
            try {
                _log4j.debug((Object)"doSoftBreak() - issue !s");
                int n2 = 0;
                while (n2 < 7) {
                    ((DeviceService)this)._toDevice.write("!".getBytes());
                    ((DeviceService)this)._toDevice.flush();
                    Thread.sleep(200L);
                    ++n2;
                }
                StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])this.menuPrefix().getBytes(), (long)5000L);
                _log4j.debug((Object)"doSoftBreak() - now in menu");
                return;
            }
            catch (TimeoutException timeoutException) {
                _log4j.info((Object)"doSoftBreak() - no menu prompt yet");
            }
            catch (Exception exception) {
                _log4j.error((Object)("Exception " + exception));
            }
            ++n;
        }
        _log4j.error((Object)"doSoftBreak() failed");
        throw new Exception("doSoftBreak() failed");
    }

    protected void powerOnCallback() {
        try {
            this.enterCommandMode();
        }
        catch (Exception exception) {
            _log4j.error((Object)("powerOnCallback(): " + exception));
        }
    }

    protected byte[] mkCmd(String string) {
        return new String(string + "\r").getBytes();
    }

    public int test() {
        return 0;
    }

    public synchronized void enterSafeMode() throws Exception {
        _log4j.info((Object)"enterSafeMode() - Setting WetLab ECO-Triplet Instrument to SAFE mode.");
        _log4j.info((Object)"enterSafeMode() - Getting WetLab ECO-Triplet attention.");
        this.enterCommandMode();
        _log4j.info((Object)"enterSafeMode() - Setting Workhorse to log internally for SAFE mode.");
        this.doCommand(ENABLE_LOG_CMD);
        this.doCommand("$pkt  10");
        this.doCommand("$int  006000");
        _log4j.info((Object)"enterSafeMode() - Saving WetLab ECO-Triplet Parameters.");
        this.doCommand(STORE_CMD, RESPONSE_DONE);
        _log4j.info((Object)"enterSafeMode() - Deploying WetLab ECO-Triplet in SAFE mode NOW.");
    }

    protected String shutdownInstrument() throws Exception {
        return "Leave instrument power off for at least one minute before switching on again";
    }

    String menuPrefix() {
        return "Ver";
    }

    public DevicePacketParser getDevicePacketParser() throws NotSupportedException {
        return super.getDevicePacketParser();
    }

    protected int readSample(byte[] byArray) throws TimeoutException, IOException, Exception {
        byte[] byArray2 = this.menuPrefix().getBytes();
        int n = 0;
        int n2 = 0;
        long l = System.currentTimeMillis();
        do {
            int n3;
            if ((n3 = this._blockingInputStream.read()) == -1) {
                _log4j.error((Object)"readSample(); error reading byte");
                throw new IOException("error reading byte");
            }
            byte by = (byte)n3;
            if (by == byArray2[n]) {
                if (++n != byArray2.length) continue;
                _log4j.info((Object)("TEST: ID=" + this.getId() + ", got complete sample at + " + System.currentTimeMillis()));
                return n2;
            }
            n = 0;
            byArray[n2++] = by;
        } while (System.currentTimeMillis() - l <= this.getSampleTimeout());
        _log4j.error((Object)"readSample(): sample timeout");
        throw new TimeoutException("wetlabs sample timeout");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Attributes
    extends InstrumentServiceAttributes {
        int averageCount = 50;
        int samplesPerPacket = 3;
        int packetsPerSet = 1;
        String packetInterval = "000000";
        boolean logEnabled = true;

        Attributes(DeviceServiceIF deviceServiceIF) {
            super(deviceServiceIF);
        }

        public void checkValues() throws InvalidPropertyException {
            if (this.samplesPerPacket <= 0) {
                throw new InvalidPropertyException(this.samplesPerPacket + ": invalid samplesPerPacket. " + "must be > 0");
            }
            if (this.averageCount <= 0) {
                throw new InvalidPropertyException(this.averageCount + ": invalid averageCount. " + "must be > 0");
            }
        }
    }
}

