/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.siam.devices.workhorse;

import java.text.ParseException;
import org.mbari.siam.devices.workhorse.WorkhorseADCP;
import org.mbari.siam.distributed.DevicePacket;
import org.mbari.siam.distributed.NotSupportedException;
import org.mbari.siam.distributed.PacketParser;
import org.mbari.siam.distributed.SensorDataPacket;

public class WorkhorsePacketParser
extends PacketParser {
    public static String REGISTRY_NAME_KEY = "registryName";
    public static String VX_KEY = "velocityX";
    public static String VY_KEY = "velocityY";
    public static String VZ_KEY = "velocityZ";
    private static final long serialVersionUID = 1L;
    protected WorkhorseADCP.PD0DataStructure _pd0Struct = new WorkhorseADCP.PD0DataStructure();

    public WorkhorsePacketParser() {
    }

    public WorkhorsePacketParser(String string) {
        super(string);
    }

    public PacketParser.Field[] parseFields(DevicePacket devicePacket) throws NotSupportedException, ParseException {
        if (!(devicePacket instanceof SensorDataPacket)) {
            throw new NotSupportedException("expecting SensorDataPacket");
        }
        PacketParser.Field[] fieldArray = new PacketParser.Field[4];
        byte[] byArray = ((SensorDataPacket)devicePacket).dataBuffer();
        if (byArray[0] != 127 || byArray[1] != 127) {
            throw new NotSupportedException("Packet not a recognized Workhorse format");
        }
        this._pd0Struct.setData(byArray);
        int[] nArray = this._pd0Struct.getVelocity(1);
        double d = 0.1 * (double)nArray[0];
        nArray = this._pd0Struct.getVelocity(2);
        double d2 = 0.1 * (double)nArray[0];
        nArray = this._pd0Struct.getVelocity(3);
        double d3 = 0.1 * (double)nArray[0];
        fieldArray[0] = new PacketParser.Field((PacketParser)this, REGISTRY_NAME_KEY, (Object)this._registryName, "string");
        fieldArray[1] = new PacketParser.Field((PacketParser)this, VX_KEY, (Object)new Double(d), "cm/s");
        fieldArray[2] = new PacketParser.Field((PacketParser)this, VY_KEY, (Object)new Double(d2), "cm/s");
        fieldArray[3] = new PacketParser.Field((PacketParser)this, VZ_KEY, (Object)new Double(d3), "cm/s");
        return fieldArray;
    }
}

