/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.siam.devices.workhorse;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.mbari.siam.core.DeviceService;
import org.mbari.siam.core.SerialInstrumentPort;
import org.mbari.siam.core.SerialPortParameters;
import org.mbari.siam.core.StreamingInstrumentService;
import org.mbari.siam.devices.workhorse.WorkhorsePacketParser;
import org.mbari.siam.distributed.DevicePacket;
import org.mbari.siam.distributed.InitializeException;
import org.mbari.siam.distributed.Instrument;
import org.mbari.siam.distributed.InstrumentServiceAttributes;
import org.mbari.siam.distributed.InvalidDataException;
import org.mbari.siam.distributed.InvalidPropertyException;
import org.mbari.siam.distributed.NotSupportedException;
import org.mbari.siam.distributed.PacketParser;
import org.mbari.siam.distributed.PowerPolicy;
import org.mbari.siam.distributed.ScheduleParseException;
import org.mbari.siam.distributed.ScheduleSpecifier;
import org.mbari.siam.distributed.SensorDataPacket;
import org.mbari.siam.distributed.ServiceAttributes;
import org.mbari.siam.distributed.TimeoutException;
import org.mbari.siam.utils.AsciiTime;
import org.mbari.siam.utils.PrintUtils;
import org.mbari.siam.utils.PrintfFormat;
import org.mbari.siam.utils.StreamUtils;
import org.mbari.util.NumberUtil;

public class StreamingWorkhorseADCP
extends StreamingInstrumentService
implements Instrument {
    static final int MAX_RESPONSE_BYTES = 4096;
    static final int MAX_SAMPLE_TRIES = 1;
    static final int MAX_CMD_TRIES = 3;
    static final int MAX_REQUEST_BYTES = 8192;
    static final int MAX_PROMPT_TRIES = 3;
    static final int MAX_BREAK_TRIES = 2;
    static final int RESPONSE_TIME = 5000;
    static final int PROMPT_RESPONSE_TIME = 3000;
    static final int ECHO_RESPONSE_TIME = 2000;
    static final int BREAK_FOR_400MS = 100000;
    static final String CMD_FORCE_PROMPT = "";
    static final String CMD_START_PINGING = "CS";
    static final String CMD_SET_RTC = "TS";
    static final String CMD_SET_FIRST_PING = "TF";
    static final String CMD_POWER_DOWN = "CZ";
    static final String CMD_SET_CF_NORMAL = "CF=11110";
    static final String CMD_SET_CF_LOGGING = "CF=11111";
    static final String CMD_SET_EX = "EX=";
    static final String CMD_DEFAULT_EX = "11010";
    static final String CMD_SAVE_PARAMETERS = "CK";
    static final String CMD_GET_DEPLOYMENT_WD = "WD?";
    static final String CMD_GET_DEPLOYMENT_WF = "WF?";
    static final String CMD_GET_DEPLOYMENT_WN = "WN?";
    static final String CMD_GET_DEPLOYMENT_WP = "WP?";
    static final String CMD_GET_DEPLOYMENT_WS = "WS?";
    static final String CMD_GET_DEPLOYMENT_WV = "WV?";
    static final String CMD_GET_DEPLOYMENT_TE = "TE?";
    static final String CMD_GET_DEPLOYMENT_TP = "TP?";
    static final String CMD_GET_DEPLOYMENT_TS = "TS?";
    static final String CMD_GET_DEPLOYMENT_EA = "EA?";
    static final String CMD_GET_DEPLOYMENT_EB = "EB?";
    static final String CMD_GET_DEPLOYMENT_ED = "ED?";
    static final String CMD_GET_DEPLOYMENT_ES = "ES?";
    static final String CMD_GET_DEPLOYMENT_EX = "EX?";
    static final String CMD_GET_DEPLOYMENT_EZ = "EZ?";
    static final String CMD_GET_DEPLOYMENT_CF = "CF?";
    static final String CMD_GET_SYSTEM_FEATURES = "OL";
    static final String CMD_GET_SYSTEM_SERIAL_CONFIG = "CB?";
    static final String CMD_GET_SYSTEM_CONFIG = "PS0";
    static final String CMD_GET_SYSTEM_TRANSFORM_MATRIX = "PS3";
    static final String CMD_GET_SYSTEM_RECORDER_SPACE = "RF";
    static final String CMD_GET_SYSTEM_COMPASS_CAL = "AC";
    static final String CMD_GET_DEPLOYMENTS_RECORDED = "RA?";
    static final String CMD_GET_RECORDER_FILE_DIR = "RR?";
    static final String CMD_GET_RECORDER_FREE_SPACE = "RF?";
    static final String RESPONSE_PROMPT = ">";
    static final byte HEADER_ID = 127;
    static final byte SOURCE_ID = 127;
    public Attributes _attributes = new Attributes(this);
    private Logger _log4j;
    protected boolean _isPinging = false;
    int _nAcquired = 0;
    protected DevicePacketParser devicePacketParser;
    protected PD0DataStructure _pd0Struct = new PD0DataStructure();
    protected InputStream _blockingInputStream;
    protected boolean _inputSynced = false;
    protected int _packetLen = 0;
    PrintfFormat _timeField = new PrintfFormat("%02d");
    static /* synthetic */ Class class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP;

    public StreamingWorkhorseADCP() throws RemoteException {
        this._log4j = Logger.getLogger((String)((class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP == null ? (class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP = StreamingWorkhorseADCP.class$("org.mbari.siam.devices.workhorse.StreamingWorkhorseADCP")) : class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP).getName() + "-0"));
    }

    protected int initInstrumentStartDelay() {
        return 2000;
    }

    protected ScheduleSpecifier createDefaultSampleSchedule() throws ScheduleParseException {
        return new ScheduleSpecifier(Integer.MAX_VALUE);
    }

    protected byte[] initPromptString() {
        return RESPONSE_PROMPT.getBytes();
    }

    protected byte[] initSampleTerminator() {
        return new byte[0];
    }

    protected int initMaxSampleBytes() {
        return 4096;
    }

    protected int initCurrentLimit() {
        return 1000;
    }

    protected PowerPolicy initInstrumentPowerPolicy() {
        return PowerPolicy.ALWAYS;
    }

    protected PowerPolicy initCommunicationPowerPolicy() {
        return PowerPolicy.WHEN_SAMPLING;
    }

    public SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException {
        this._log4j.info((Object)("getSerialParameters(): baud=" + this._attributes.baud));
        return new SerialPortParameters(this._attributes.baud, 8, 0, 1);
    }

    protected void initializeInstrument() throws InitializeException, Exception {
        this._log4j = Logger.getLogger((String)((class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP == null ? (class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP = StreamingWorkhorseADCP.class$("org.mbari.siam.devices.workhorse.StreamingWorkhorseADCP")) : class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP).getName() + "-" + this.getId()));
        this._log4j.info((Object)("Initializing Workhorse " + this.getId()));
        if (!(((DeviceService)this)._instrumentPort instanceof SerialInstrumentPort)) {
            throw new Exception("Service needs SerialInstrumentPort");
        }
        this._blockingInputStream = ((SerialInstrumentPort)((DeviceService)this)._instrumentPort).getSerialPort().getInputStream();
        this.setMaxSampleTries(1);
        this.managePowerWake();
        if (this._attributes.preConfigured) {
            this._log4j.info((Object)"Instrument has been pre-configured; ignore configuration attributes");
            this.enterCommandMode();
            String string = this.sendRequest(CMD_GET_DEPLOYMENT_TE);
            this._log4j.info((Object)("TE response: " + string));
            String string2 = this.getProperty(string, CMD_GET_DEPLOYMENT_TE);
            String[] stringArray = this.parseProperty(string2, ":.", 3);
            long l = 0L;
            try {
                l = (long)(Integer.parseInt(stringArray[0]) * 3600000 + Integer.parseInt(stringArray[1]) * 60000) + (long)(Float.parseFloat(stringArray[2]) * 1000.0f + 5000.0f);
            }
            catch (Exception exception) {
                throw new Exception("Unable to parse ensemble interval: " + string2);
            }
            if (((InstrumentServiceAttributes)this._attributes).timeSynch) {
                this.setClock();
            }
            string = this.sendRequest(CMD_GET_DEPLOYMENT_CF).trim();
            this._log4j.info((Object)("initializeInstrument(): response = " + string));
            string2 = this.getProperty(string, CMD_GET_DEPLOYMENT_CF).trim();
            this._log4j.info((Object)("initializeInstrument(): property=" + string2 + ", char 3=" + string2.charAt(3)));
            this._log4j.info((Object)("initializeInstrument(): property char 3=" + string2.charAt(3)));
            if (string2.charAt(3) != '1') {
                this._log4j.info((Object)"Enabling serial output");
                stringArray = this.parseProperty(string2, " ", 1);
                StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
                stringBuffer.setCharAt(3, '1');
                this.sendCommand("CF=" + new String(stringBuffer));
            }
            this.setSampleTimeout(l);
            this._log4j.info((Object)"Start pinging");
            this.exitCommandMode();
            this.managePowerSleep();
            return;
        }
        this.setSampleTimeout(this._attributes.ensembleIntervalSec * 1000 + 5000);
        try {
            try {
                this.enterCommandMode();
                this._log4j.debug((Object)"initializeInstrument() - Reviewing Workhorse logging attribute.");
                if (!this._attributes.internalLog) {
                    this._log4j.info((Object)"initializeInstrument() - Disabling Workhorse internal log.");
                    this.sendCommand(CMD_SET_CF_NORMAL);
                } else {
                    this._log4j.info((Object)"initializeInstrument() - Setting Workhorse to log internally.");
                    this.sendCommand(CMD_SET_CF_LOGGING);
                }
                this._log4j.info((Object)("initializeInstrument() - Setting Workhorse Coordinate system to " + this._attributes.exCommand));
                this.sendCommand(CMD_SET_EX + this._attributes.exCommand);
                this._log4j.info((Object)"initializeInstrument() - Setting Workhorse normal sample interval (TE).");
                int n = this._attributes.ensembleIntervalSec / 3600;
                int n2 = this._attributes.ensembleIntervalSec % 3600;
                int n3 = n2 / 60;
                int n4 = n2 % 60;
                String string = "TE" + this._timeField.sprintf(n) + ":" + this._timeField.sprintf(n3) + ":" + this._timeField.sprintf(n4) + ".00";
                this._log4j.debug((Object)("send TE command: " + string));
                this.sendCommand(string);
                this._log4j.debug((Object)("TE now set to " + this.sendRequest(CMD_GET_DEPLOYMENT_TE)));
                this._log4j.info((Object)"initializeInstrument() - Setting Workhorse normal Pings Per EnSemble (WP).");
                this.sendCommand("WP" + this._attributes.pingsPerEnsemble);
                this._log4j.info((Object)"initializeInstrument() - Setting Workhorse normal Time Per Ping (TP).");
                string = CMD_FORCE_PROMPT;
                if (this._attributes.secPerPing > 0) {
                    string = "TP " + this._timeField.sprintf(this._attributes.secPerPing / 60) + ":" + this._timeField.sprintf(this._attributes.secPerPing % 60) + ".00";
                    this._log4j.debug((Object)("Sending " + string));
                    this.sendCommand(string);
                } else if (this._attributes.msecPerPing > 0) {
                    string = "TP 00:" + this._timeField.sprintf(this._attributes.msecPerPing / 1000) + "." + this._timeField.sprintf(this._attributes.msecPerPing % 1000 / 10);
                    this._log4j.debug((Object)("Sending " + string));
                    this.sendCommand(string);
                }
                this._log4j.debug((Object)"Done setting ping time");
                String string3 = this.sendRequest(CMD_GET_DEPLOYMENT_TE);
                this._log4j.debug((Object)("send TE request response: " + string3));
                String string4 = this.getProperty(string3, CMD_GET_DEPLOYMENT_TE);
                String[] stringArray = this.parseProperty(string4, ":.", 3);
                this._log4j.debug((Object)("TE property: " + string4));
                string3 = this.sendRequest(CMD_GET_DEPLOYMENT_TP);
                string4 = this.getProperty(string3, CMD_GET_DEPLOYMENT_TP);
                stringArray = this.parseProperty(string4, ":.", 2);
                this._log4j.debug((Object)("TP property: " + string4));
                string3 = this.sendRequest(CMD_GET_DEPLOYMENT_WP);
                this._log4j.debug((Object)("send WP request response: " + string3));
                string4 = this.getProperty(string3, CMD_GET_DEPLOYMENT_WP);
                string = "WN " + this._attributes.nDepthCells;
                this._log4j.debug((Object)("Sending " + string));
                this.sendCommand(string);
                string = "WS " + this._attributes.depthCellCm;
                this._log4j.debug((Object)("Sending " + string));
                this.sendCommand(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InitializeException("parseInt()" + numberFormatException);
            }
            catch (InvalidPropertyException invalidPropertyException) {
                throw new InitializeException("getProperty()" + (Object)((Object)invalidPropertyException));
            }
            catch (Exception exception) {
                throw new InitializeException("sendRequest() " + exception);
            }
            Object var10_18 = null;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            this.sendCommand(CMD_SAVE_PARAMETERS);
            this.exitCommandMode();
            this.managePowerSleep();
            throw throwable;
        }
        this.sendCommand(CMD_SAVE_PARAMETERS);
        this.exitCommandMode();
        this.managePowerSleep();
        this._log4j.info((Object)"Initializing completed");
    }

    protected int readSample(byte[] byArray) throws TimeoutException, IOException, Exception {
        long l = System.currentTimeMillis();
        if (!this._inputSynced) {
            this._log4j.info((Object)"readSample(); call syncToPacket()");
            this._packetLen = this.syncToPacket(this._blockingInputStream, byArray, this.getSampleTimeout());
        } else {
            this._log4j.info((Object)"readSample(); stream is synced, call readNextPacket()");
            this._packetLen = this.readNextPacket(this._blockingInputStream, this._packetLen, byArray, this.getSampleTimeout());
        }
        this._log4j.info((Object)("Data captured: " + this._packetLen + " bytes, " + (System.currentTimeMillis() - l) / 1000L + " sec"));
        this._log4j.info((Object)("data: " + byArray));
        return this._packetLen;
    }

    protected int readNextPacket(InputStream inputStream, int n, byte[] byArray, long l) throws TimeoutException, IOException, Exception {
        int n2;
        this._log4j.debug((Object)("readNextPacket(): try to read " + n + " bytes"));
        long l2 = System.currentTimeMillis();
        int n3 = 0;
        do {
            if (System.currentTimeMillis() - l2 > l) {
                throw new TimeoutException("StreamingWorkhorseADCP.readNextPacket() timed out");
            }
            n2 = inputStream.read(byArray, n3, n - n3);
            if (n2 != -1) continue;
            this._log4j.error((Object)"readNextPacket(): end-of-stream");
            throw new IOException("StreamingSBE19.readEnsemble(): end-of-stream");
        } while ((n3 += n2) < n);
        this._log4j.debug((Object)("readNextPacket(): return " + n));
        return n;
    }

    protected int syncToPacket(InputStream inputStream, byte[] byArray, long l) throws TimeoutException, IOException, Exception {
        byte by = 0;
        byte by2 = 0;
        int n = 0;
        int n2 = 0;
        while (true) {
            this._log4j.info((Object)"syncToPacket() instream.read()");
            n2 = inputStream.read();
            this._log4j.info((Object)("syncToPacket() instream.read() returned " + n2));
            if (n2 == -1) {
                this._log4j.error((Object)"syncToPacket(): end-of-stream looking for header");
                throw new IOException("syncToPacket(): end-of-stream");
            }
            by = (byte)n2;
            this._log4j.info((Object)("syncToPacket(): looking for hdr, b=" + by));
            if (by == 127 && by2 == 127) break;
            by2 = by;
        }
        byArray[n++] = 127;
        byArray[n++] = 127;
        long l2 = System.currentTimeMillis();
        this._log4j.info((Object)"syncToPacket(): got header");
        int n3 = 0;
        if (inputStream.read(byArray, n, 2) == -1) {
            this._log4j.error((Object)"syncToPacket(): end-of-stream reading packet size");
            throw new IOException("syncToPacket(): end-of-stream");
        }
        n3 = this.mkInt(byArray[2], byArray[3]) + 2;
        this._log4j.info((Object)("syncToPacket() - expected packetSize=" + n3));
        this._log4j.info((Object)("syncToPacket(): try to read " + (n3 - (n += 2))));
        int n4 = n;
        do {
            if ((n2 = inputStream.read(byArray, n4, n3 - n4)) == -1) {
                this._log4j.error((Object)"syncToPacket(): end-of-stream reading remainder");
                throw new IOException("syncToPacket(): end-of-stream");
            }
            this._log4j.info((Object)("syncToPacket() - got " + n2 + " bytes"));
        } while ((n4 += n2) < n3);
        this._log4j.info((Object)("syncToPacket(): got pckt in " + (System.currentTimeMillis() - l2) + " msec, return " + n3));
        return n3;
    }

    protected void validateSample(byte[] byArray, int n) throws InvalidDataException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n - 2) {
            n2 += this.mkInt(byArray[n3], (byte)0);
            ++n3;
        }
        int n4 = this.mkInt(byArray[n3], byArray[n3 + 1]);
        this._log4j.debug((Object)("validateSample(): sum=" + (n2 %= 65536) + ", checksum=" + n4));
        if (n2 != n4) {
            this._log4j.error((Object)"Invalid checksum");
            this._inputSynced = false;
            throw new InvalidDataException("Checksum error");
        }
        this._log4j.debug((Object)"validateSample(): checksum ok");
        this._inputSynced = true;
    }

    public PacketParser getParser() throws NotSupportedException {
        return new WorkhorsePacketParser(((ServiceAttributes)this._attributes).registryName);
    }

    public Object parseDataPacket(SensorDataPacket sensorDataPacket) throws InvalidDataException {
        try {
            PacketParser packetParser = this.getParser();
            return packetParser.parseFields((DevicePacket)sensorDataPacket);
        }
        catch (NotSupportedException notSupportedException) {
            this._log4j.error((Object)notSupportedException.toString());
        }
        catch (ParseException parseException) {
            throw new InvalidDataException("ParseException caught: " + parseException.toString());
        }
        return null;
    }

    protected void startStreaming() throws Exception {
        ((DeviceService)this)._toDevice.write(this.mkCmd(CMD_START_PINGING));
        ((DeviceService)this)._toDevice.flush();
        this._isPinging = true;
    }

    protected void stopStreaming() throws Exception {
        this.enterCommandMode();
        this._isPinging = false;
    }

    protected boolean isStreaming() {
        return this._isPinging;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getInstrumentStateMetadata() {
        boolean bl = this.isStreaming();
        if (bl) {
            try {
                this.stopStreaming();
            }
            catch (Exception exception) {
                this._log4j.error((Object)("getInstrumentStateMetadata(): Couldn't stop streaming: " + exception));
            }
        }
        String string = CMD_FORCE_PROMPT;
        this.enterCommandMode();
        string = "ADCP metadata:";
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_WD).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_WF).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_WN).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_WP).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_WS).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_WV).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_TE).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_TP).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_TS).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_EA).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_EB).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_ED).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_ES).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_EX).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_EZ).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_DEPLOYMENT_CF).trim();
        Thread.sleep(250L);
        string = string + "\nNumber of deployments recorded: " + this.sendRequest(CMD_GET_DEPLOYMENTS_RECORDED).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_RECORDER_FILE_DIR).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_RECORDER_FREE_SPACE).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_SYSTEM_SERIAL_CONFIG).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_SYSTEM_CONFIG).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_SYSTEM_TRANSFORM_MATRIX).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_SYSTEM_RECORDER_SPACE).trim();
        Thread.sleep(250L);
        string = string + "\n" + this.sendRequest(CMD_GET_SYSTEM_COMPASS_CAL).trim();
        this._log4j.debug((Object)("getInstrumentMetadata: metadata= " + string));
        this._log4j.debug((Object)"getInstrumentMetadata: return to sampling ");
        Object var5_4 = null;
        if (!bl) return string.trim().getBytes();
        try {
            this.startStreaming();
            return string.trim().getBytes();
        }
        catch (Exception exception) {
            this._log4j.error((Object)("getInstrumentStateMetadata(): Couldn't start streaming: " + exception));
        }
        return string.trim().getBytes();
        {
            catch (Exception exception) {
                this._log4j.error((Object)("getInstrumentMetadata: Exception - " + exception), (Throwable)exception);
                string = string + "Error acquiring instrument metadata";
                Object var5_5 = null;
                if (!bl) return string.trim().getBytes();
                try {
                    this.startStreaming();
                    return string.trim().getBytes();
                }
                catch (Exception exception2) {
                    this._log4j.error((Object)("getInstrumentStateMetadata(): Couldn't start streaming: " + exception2));
                }
                return string.trim().getBytes();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!bl) throw throwable;
            try {
                this.startStreaming();
                throw throwable;
            }
            catch (Exception exception) {
                this._log4j.error((Object)("getInstrumentStateMetadata(): Couldn't start streaming: " + exception));
            }
            throw throwable;
        }
    }

    public void setClock() {
        boolean bl = this._isPinging;
        try {
            this.enterCommandMode();
            String string = AsciiTime.getDate((String)"YY/MM/DD");
            String string2 = AsciiTime.getTime((String)"HH:mm:ss");
            this.sendCommand(CMD_SET_RTC + string + "," + string2);
            this._log4j.info((Object)("setClock(): " + string + ", " + string2));
            if (bl) {
                this.exitCommandMode();
            }
        }
        catch (Exception exception) {
            this._log4j.error((Object)("Caught exception in setClock(): " + exception));
        }
    }

    public org.mbari.siam.distributed.DevicePacketParser getDevicePacketParser() throws NotSupportedException {
        if (this.devicePacketParser == null) {
            if (this._log4j.isInfoEnabled()) {
                this._log4j.debug((Object)"Creating a DevicePacketParser");
            }
            this.devicePacketParser = new DevicePacketParser();
        }
        return this.devicePacketParser;
    }

    protected String sendRequest(String string) throws Exception {
        byte[] byArray = new byte[8192];
        int n = 0;
        while (n < 3) {
            try {
                ((DeviceService)this)._fromDevice.flush();
                byte[] byArray2 = this.mkCmd(string);
                ((DeviceService)this)._toDevice.write(byArray2);
                ((DeviceService)this)._toDevice.flush();
                this._log4j.info((Object)("sendRequest: wrote request " + new String(byArray2)));
                String string2 = new String(byArray2) + "\n";
                StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])string2.getBytes(), (long)2000L);
                this._log4j.info((Object)("sendRequest: got echo response: " + new String(byArray).trim()));
                StreamUtils.readUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])byArray, (byte[])RESPONSE_PROMPT.getBytes(), (long)5000L);
                return new String(byArray).trim();
            }
            catch (IOException iOException) {
                this._log4j.error((Object)("sendRequest caught IOException " + iOException));
                throw new Exception("sendRequest(" + string + ") - Stream I/O failure");
            }
            catch (NullPointerException nullPointerException) {
                this._log4j.error((Object)("sendRequest caught Null Pointer Exception " + nullPointerException));
                throw new Exception("sendRequest(" + string + ") - Null pointer");
            }
            catch (TimeoutException timeoutException) {
                this._log4j.error((Object)("sendRequest caught Timeout Exception: " + (Object)((Object)timeoutException) + "Request=" + string));
            }
            catch (Exception exception) {
                this._log4j.error((Object)("sendRequest " + string + " caught Exception " + exception));
            }
            ((DeviceService)this)._toDevice.write(this.mkCmd(CMD_FORCE_PROMPT));
            ((DeviceService)this)._toDevice.flush();
            Thread.sleep(500L);
            ++n;
        }
        throw new Exception("sendRequest(" + string + ") - Maximum retries attempted");
    }

    protected void sendCommand(String string) throws Exception {
        int n = 0;
        while (n < 3) {
            try {
                this._log4j.info((Object)("sendCommand: " + string));
                ((DeviceService)this)._fromDevice.flush();
                ((DeviceService)this)._toDevice.write(this.mkCmd(string));
                ((DeviceService)this)._toDevice.flush();
                StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])RESPONSE_PROMPT.getBytes(), (long)5000L);
                return;
            }
            catch (IOException iOException) {
                this._log4j.error((Object)("sendCommand caught IOException " + iOException));
                throw new Exception("sendCommand(" + string + ") - Stream I/O failure");
            }
            catch (NullPointerException nullPointerException) {
                this._log4j.error((Object)("sendCommand caught Null Pointer Exception " + nullPointerException));
                throw new Exception("sendCommand(" + string + ") - Null pointer");
            }
            catch (TimeoutException timeoutException) {
                this._log4j.error((Object)("sendCommand caught Timeout Exception: " + (Object)((Object)timeoutException) + "Cmd=" + string));
            }
            catch (Exception exception) {
                this._log4j.error((Object)("sendCommand caught Exception " + exception));
            }
            ((DeviceService)this)._toDevice.write(this.mkCmd(CMD_FORCE_PROMPT));
            ((DeviceService)this)._toDevice.flush();
            Thread.sleep(500L);
            ++n;
        }
        throw new Exception("sendCommand(" + string + ") - Maximum retries attempted");
    }

    protected void enterCommandMode() throws Exception {
        int n = 0;
        while (n < 2) {
            this._log4j.debug((Object)("enterCommandMode() - send break #" + n));
            this.sendBreak();
            Thread.sleep(1500L);
            int n2 = 0;
            while (n2 < 3) {
                this._log4j.debug((Object)("enterCommandMode() - force prompt #" + n2));
                ((DeviceService)this)._toDevice.write(this.mkCmd(CMD_FORCE_PROMPT));
                ((DeviceService)this)._toDevice.flush();
                try {
                    StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])RESPONSE_PROMPT.getBytes(), (long)3000L);
                    this._log4j.debug((Object)"enterCommandMode(): returning");
                    return;
                }
                catch (IOException iOException) {
                    this._log4j.error((Object)("enterCommandMode caught IOException " + iOException));
                }
                catch (NullPointerException nullPointerException) {
                    this._log4j.error((Object)("enterCommandMode caught Null Pointer Exception " + nullPointerException));
                }
                catch (TimeoutException timeoutException) {
                    this._log4j.error((Object)("enterCommandMode caught Timeout Exception: " + (Object)((Object)timeoutException)));
                }
                catch (Exception exception) {
                    this._log4j.error((Object)("enterCommandMode caught Exception " + exception));
                }
                Thread.sleep(1500L);
                ++n2;
            }
            ++n;
        }
        throw new Exception("enterCommandMode() - Maximum retries attempted");
    }

    protected void exitCommandMode() throws IOException, Exception {
        this._log4j.debug((Object)"exitCommandMode:sending CS");
        ((DeviceService)this)._toDevice.write(this.mkCmd(CMD_START_PINGING));
        ((DeviceService)this)._toDevice.flush();
    }

    protected void sendBreak() {
        if (((DeviceService)this)._instrumentPort instanceof SerialInstrumentPort) {
            this._log4j.debug((Object)"Sending break.....");
            SerialInstrumentPort serialInstrumentPort = (SerialInstrumentPort)((DeviceService)this)._instrumentPort;
            int n = 0;
            while (n < this._attributes.numBreaks) {
                serialInstrumentPort.sendBreak(100000);
                ++n;
            }
        }
    }

    protected byte[] mkCmd(String string) {
        if (!this._attributes.oldProtocol) {
            string = string.replace('=', ' ');
        }
        return new String(string + "\r").getBytes();
    }

    protected int mkInt(byte by, byte by2) {
        int n = by & 0xFF;
        int n2 = by2 & 0xFF;
        return n + (n2 << 8);
    }

    protected String getProperty(String string, String string2) throws InvalidPropertyException {
        this._log4j.info((Object)("getProperty(): response=" + string));
        if (this._attributes.oldProtocol) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
            int n = 0;
            while (stringTokenizer.countTokens() > 0) {
                String string3 = stringTokenizer.nextToken();
                if (n++ != 1) continue;
                return string3.trim();
            }
        } else {
            StringTokenizer stringTokenizer = null;
            if (string.indexOf(61) == -1) {
                this._log4j.debug((Object)"assume ' ' delimiter");
                stringTokenizer = new StringTokenizer(string, " ", false);
            } else {
                this._log4j.debug((Object)"assume '=' delimiter");
                stringTokenizer = new StringTokenizer(string, "=", false);
            }
            int n = 0;
            while (stringTokenizer.countTokens() > 0) {
                String string4 = stringTokenizer.nextToken();
                if (n++ != 1) continue;
                return string4;
            }
        }
        this._log4j.error((Object)("getProperty() - Invalid property: " + string));
        throw new InvalidPropertyException("Invalid property: " + string + " , in response to " + string2);
    }

    protected String[] parseProperty(String string, String string2, int n) throws InvalidPropertyException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        if (n > stringTokenizer.countTokens()) {
            this._log4j.error((Object)("parseProperty() - Invalid property: " + string));
            throw new InvalidPropertyException("Invalid Workhorse property: " + string);
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public void printData(byte[] byArray) {
        PrintUtils.printFull((byte[])byArray, (int)0, (int)64);
    }

    public int test() {
        return 0;
    }

    protected void powerOnCallback() throws Exception {
        this._log4j.debug((Object)("powerOnCallback(): sleeping for " + this._attributes.warmupSec + " seconds."));
        Thread.sleep(this._attributes.warmupSec * 1000);
    }

    protected String shutdownInstrument() throws Exception {
        if (this.nPowerRequests() == 0) {
            return "Never powered up; assume instrument in low-power sleep";
        }
        this._log4j.debug((Object)"shutdownPort() - managePowerWake()");
        this.managePowerWake();
        this._log4j.debug((Object)"shutdownPort() - send multi breaks!");
        int n = 0;
        while (n < 3) {
            this.sendBreak();
            Thread.sleep(500L);
            ++n;
        }
        this._log4j.debug((Object)"shutdownPort() - enterCommandMode()");
        this.enterCommandMode();
        this._log4j.debug((Object)"shutdownPort() - Power down the ADCP");
        ((DeviceService)this)._fromDevice.flush();
        ((DeviceService)this)._toDevice.write(this.mkCmd(CMD_POWER_DOWN));
        ((DeviceService)this)._toDevice.flush();
        StreamUtils.skipUntil((InputStream)((DeviceService)this)._fromDevice, (byte[])"Powering Down".getBytes(), (long)5000L);
        return "Workhorse in low-powered sleep";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PD0DataStructure
    implements DataStructure,
    Serializable {
        private byte[] data;
        public static final byte ID_HEADER = 127;
        public static final byte ID_DATA_SOURCE = 127;
        public static final int ID_FIXED_LEADER = 0;
        public static final int ID_VELOCITY = 256;
        public static final int ID_CORRELATION_MAGNITUDE = 512;
        public static final int ID_ECHO_INTENSITY = 768;
        public static final int ID_PERCENT_GOOD = 1024;
        public static final int ID_VARIABLE_LEADER = 128;
        public static final int DATATYPE_FIXED_LEADER = 1;
        public static final int DATATYPE_VARIABLE_LEADER = 2;
        private static Logger _log4j = Logger.getLogger((Class)(class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP$PD0DataStructure == null ? (class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP$PD0DataStructure = PD0DataStructure.class$("org.mbari.siam.devices.workhorse.StreamingWorkhorseADCP$PD0DataStructure")) : class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP$PD0DataStructure));
        static /* synthetic */ Class class$org$mbari$siam$devices$workhorse$StreamingWorkhorseADCP$PD0DataStructure;

        public int getShort(int n) {
            short s = (short)(this.data[n] & 0xFF);
            short s2 = (short)(this.data[n + 1] & 0xFF);
            return s | s2 << 8;
        }

        public byte[] getBytes(int n, int n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.data, n, byArray, 0, n2);
            return byArray;
        }

        public void setData(byte[] byArray) {
            boolean bl = false;
            try {
                boolean bl2 = bl = byArray != null && byArray[0] == 127 && byArray[1] == 127;
                if (bl) {
                    this.data = byArray;
                    bl = this.getShort(this.getHeaderLength() + 1) != 0;
                }
            }
            catch (Exception exception) {
                if (_log4j.isDebugEnabled()) {
                    _log4j.debug((Object)"Not a valid workhorse ensemble", (Throwable)exception);
                }
                bl = false;
            }
            if (!bl) {
                this.data = null;
                throw new IllegalArgumentException("Not a a valid workhorse data ensemble");
            }
        }

        public byte[] getData() {
            return this.data;
        }

        public int getNumberOfBytesInEnsemble() {
            return this.getShort(2);
        }

        public int getNumberOfDataTypes() {
            return this.data[5];
        }

        public int getHeaderLength() {
            return 2 * this.getNumberOfDataTypes() + 6;
        }

        public int getOffsetForDataType(int n) {
            if (n == 0 || n > this.getNumberOfDataTypes()) {
                throw new IllegalArgumentException("The valid range for data-types is 1-" + this.getNumberOfDataTypes() + ". The value " + n + " is invalid.");
            }
            return this.getShort(6 + (n - 1) * 2);
        }

        public int getOffsetForFixedLeader() {
            return this.getOffsetForDataType(1);
        }

        public int getNumberOfBeams() {
            return NumberUtil.toUnsignedInt((byte)this.data[this.getOffsetForFixedLeader() + 8]);
        }

        public int getNumberOfCells() {
            return NumberUtil.toUnsignedInt((byte)this.data[this.getOffsetForFixedLeader() + 9]);
        }

        public int getPingsPerEnsemble() {
            return this.getShort(this.getOffsetForFixedLeader() + 10);
        }

        public int getDepthCellLength() {
            return this.getShort(this.getOffsetForFixedLeader() + 12);
        }

        public int getErrorVelocityMaximum() {
            return this.getShort(this.getOffsetForFixedLeader() + 20);
        }

        public int getBinOneDistance() {
            return this.getShort(this.getOffsetForFixedLeader() + 32);
        }

        public int getOffsetForVariableLeader() {
            return this.getOffsetForDataType(2);
        }

        public int getSpeedOfSound() {
            return this.getShort(this.getOffsetForVariableLeader() + 14);
        }

        public float getDepthOfTransducer() {
            return (float)this.getShort(this.getOffsetForVariableLeader() + 16) * 0.1f;
        }

        public float getHeading() {
            return (float)this.getShort(this.getOffsetForVariableLeader() + 18) * 0.01f;
        }

        public float getPitch() {
            return (float)this.getShort(this.getOffsetForVariableLeader() + 20) * 0.01f;
        }

        public float getRoll() {
            return (float)this.getShort(this.getOffsetForVariableLeader() + 22) * 0.01f;
        }

        public int getSalinity() {
            return this.getShort(this.getOffsetForVariableLeader() + 24);
        }

        public float getTemperature() {
            return (float)this.getShort(this.getOffsetForVariableLeader() + 26) * 0.01f;
        }

        public int[] getVelocity(int n) {
            int n2;
            if (n < 1 || n > 4) {
                throw new IllegalArgumentException("Beam number must be between 1 and 4. You specified " + n);
            }
            int n3 = -1;
            int n4 = this.getNumberOfDataTypes();
            int n5 = 3;
            while (n5 <= n4) {
                int n6 = this.getOffsetForDataType(n5);
                n2 = this.getShort(n6);
                if (n2 == 256) {
                    n3 = n6;
                    break;
                }
                ++n5;
            }
            int[] nArray = null;
            if (n3 > 0) {
                n2 = this.getNumberOfBeams();
                n3 += 2 + (n - 1) * 2;
                nArray = new int[this.getNumberOfCells()];
                int n7 = 0;
                while (n7 < nArray.length) {
                    nArray[n7] = NumberUtil.toShort((byte[])this.getBytes(n3, 2), (boolean)true);
                    n3 += n2 * 2;
                    ++n7;
                }
            }
            return nArray;
        }

        public int[] getCorrelationMagnitude(int n) {
            return this.getValues(n, 512);
        }

        public float[] getEchoIntensity(int n) {
            float[] fArray;
            int[] nArray = this.getValues(n, 768);
            if (nArray != null) {
                fArray = new float[nArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    fArray[n2] = (float)nArray[n2] * 0.45f;
                    ++n2;
                }
            } else {
                fArray = null;
            }
            return fArray;
        }

        public int[] getPercentGood(int n) {
            return this.getValues(n, 1024);
        }

        private int[] getValues(int n, int n2) {
            int n3;
            if (n < 1 || n > 4) {
                throw new IllegalArgumentException("Beam number must be between 1 and 4. You specified " + n);
            }
            int n4 = -1;
            int n5 = this.getNumberOfDataTypes();
            int n6 = 3;
            while (n6 <= n5) {
                int n7 = this.getOffsetForDataType(n6);
                n3 = this.getShort(n7);
                if (n3 == n2) {
                    n4 = n7;
                    break;
                }
                ++n6;
            }
            int[] nArray = null;
            if (n4 > 0) {
                n3 = this.getNumberOfBeams();
                n4 += 2 + (n - 1);
                nArray = new int[this.getNumberOfCells()];
                int n8 = 0;
                while (n8 < nArray.length) {
                    nArray[n8] = NumberUtil.toUnsignedInt((byte)this.data[n4]);
                    n4 += n3;
                    ++n8;
                }
            }
            return nArray;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface DataStructure {
    }

    class DevicePacketParser
    extends org.mbari.siam.distributed.DevicePacketParser {
        private final PD0DataStructure dataStructure = new PD0DataStructure();

        DevicePacketParser() {
        }

        protected void parseFields(DevicePacket devicePacket) throws NotSupportedException, Exception {
            if (devicePacket == null || !(devicePacket instanceof SensorDataPacket)) {
                throw new NotSupportedException("Expected a SensorDataPacket");
            }
            SensorDataPacket sensorDataPacket = (SensorDataPacket)devicePacket;
            byte[] byArray = sensorDataPacket.dataBuffer();
            if (byArray[0] == 127 && byArray[1] == 127) {
                this.dataStructure.setData(byArray);
                int n = this.dataStructure.getNumberOfBeams();
                this.addMeasurement("nBeams", "Number of beams", "count", n);
                this.addMeasurement("nCells", "Number of cells", "count", this.dataStructure.getNumberOfCells());
                this.addMeasurement("heading", "Heading of ADCP", "degrees", new Float(this.dataStructure.getHeading()));
                this.addMeasurement("pitch", "Pitch of ADCP", "degrees", new Float(this.dataStructure.getPitch()));
                this.addMeasurement("roll", "Heading of ADCP", "degrees", new Float(this.dataStructure.getRoll()));
                this.addMeasurement("pings", "Pings per ensemble", "count", this.dataStructure.getPingsPerEnsemble());
                this.addMeasurement("depth", "Depth of transducer", "meters", new Float(this.dataStructure.getDepthOfTransducer()));
                int n2 = 1;
                while (n2 <= n) {
                    int[] nArray;
                    int[] nArray2;
                    float[] fArray;
                    int[] nArray3 = this.dataStructure.getVelocity(n2);
                    if (nArray3 != null) {
                        this.addArrayMeasurement("velocity-" + n2, "Velocity for beam " + n2, "mm/s", nArray3);
                    }
                    if ((fArray = this.dataStructure.getEchoIntensity(n2)) != null) {
                        this.addArrayMeasurement("echoIntensity-" + n2, "Echo Intensity for beam " + n2, "dB", fArray);
                    }
                    if ((nArray2 = this.dataStructure.getCorrelationMagnitude(n2)) != null) {
                        this.addArrayMeasurement("correlationMagnitude-" + n2, "Correlation Magnitude for beam " + n2, "[0=bad,255=good]", nArray2);
                    }
                    if ((nArray = this.dataStructure.getPercentGood(n2)) != null) {
                        this.addArrayMeasurement("percentGood-" + n2, "Percent Good for beam " + n2, "%", nArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public class Attributes
    extends StreamingInstrumentService.Attributes {
        boolean oldProtocol = false;
        boolean preConfigured = false;
        boolean internalLog = false;
        int baud = 9600;
        int ensembleIntervalSec = 15;
        int pingsPerEnsemble = 10;
        int secPerPing = 1;
        int msecPerPing = 0;
        int nDepthCells = 10;
        int depthCellCm = 100;
        int warmupSec = 150;
        int numBreaks = 1;
        int subSample = 1;
        String exCommand = "11010";

        public Attributes(StreamingInstrumentService streamingInstrumentService) {
            super((StreamingInstrumentService)StreamingWorkhorseADCP.this, streamingInstrumentService);
            ((InstrumentServiceAttributes)this).summaryVars = new String[]{"velocity-1", "velocity-2", "velocity-3", "velocity-4"};
        }

        public void checkValues() throws InvalidPropertyException {
        }
    }
}

